<?php
/********************************************************************************
*  Copyright 2015 Conab - Companhia Nacional de Abastecimento                   *
*                                                                               *
*  Este arquivo  parte do Sistema SIAUDI.                                      *
*                                                                               *
*  SIAUDI   um software livre; voc pode redistribui-lo e/ou                   *
*  modific-lo sob os termos da Licena Pblica Geral GNU conforme              *
*  publicada pela Free Software Foundation; tanto a verso 2 da                 *
*  Licena, como (a seu critrio) qualquer verso posterior.                    *
*                                                                               *
*  SIAUDI  distribudo na expectativa de que seja til,                        *
*  porm, SEM NENHUMA GARANTIA; nem mesmo a garantia implcita                  *
*  de COMERCIABILIDADE OU ADEQUAO A UMA FINALIDADE ESPECFICA.                *
*  Consulte a Licena Pblica Geral do GNU para mais detalhes em portugus:     *
*  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt                     *
*                                                                               *
*  Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU             *
*  junto com este programa; se no, escreva para a Free Software                *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*                                                                               *
*  Sistema   : SIAUDI - Sistema de Auditoria Interna                            *
*  Data      : 05/2015                                                          *
*                                                                               *
********************************************************************************/
?>
<?php

/**
 * This is the model base class for the table "{{feriado}}".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "Feriado".
 *
 * Columns in table "{{feriado}}" available as properties of the model,
 * and there are no model relations.
 *
 * @property string $data_feriado
 * @property string $nome_feriado
 *
 */
abstract class BaseFeriado extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return '{{feriado}}';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'Feriado|Feriados', $n);
	}

	public static function representingColumn() {
		return 'nome_feriado';
	}

	public function rules() {
		return array(
			array('data_feriado, nome_feriado, repetir_todo_ano', 'required'),
			array('nome_feriado', 'length', 'max'=>60),
			array('data_feriado, nome_feriado', 'safe', 'on'=>'search'),
		);
	}

	public function relations() {
		return array(
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'data_feriado' => Yii::t('app', 'Data'),
			'nome_feriado' => Yii::t('app', 'Descrio'),
			'repetir_todo_ano' => Yii::t('app', 'Repetir todo ano'),
		);
	}

	public function search() {
		$criteria = new CDbCriteria;

		$criteria->compare('data_feriado', $this->data_feriado, true);
                if ($this->nome_feriado){
                        $criteria->condition="nome_feriado ilike :input";
                        $criteria->params=array(":input"=>"%".$this->nome_feriado."%");
                }

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}
}