<?php
/********************************************************************************
*  Copyright 2015 Conab - Companhia Nacional de Abastecimento                   *
*                                                                               *
*  Este arquivo  parte do Sistema SIAUDI.                                      *
*                                                                               *
*  SIAUDI   um software livre; voc pode redistribui-lo e/ou                   *
*  modific-lo sob os termos da Licena Pblica Geral GNU conforme              *
*  publicada pela Free Software Foundation; tanto a verso 2 da                 *
*  Licena, como (a seu critrio) qualquer verso posterior.                    *
*                                                                               *
*  SIAUDI  distribudo na expectativa de que seja til,                        *
*  porm, SEM NENHUMA GARANTIA; nem mesmo a garantia implcita                  *
*  de COMERCIABILIDADE OU ADEQUAO A UMA FINALIDADE ESPECFICA.                *
*  Consulte a Licena Pblica Geral do GNU para mais detalhes em portugus:     *
*  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt                     *
*                                                                               *
*  Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU             *
*  junto com este programa; se no, escreva para a Free Software                *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*                                                                               *
*  Sistema   : SIAUDI - Sistema de Auditoria Interna                            *
*  Data      : 05/2015                                                          *
*                                                                               *
********************************************************************************/
?>
<?php

/**
 * This is the model base class for the table "{{homens_hora}}".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "HomensHora".
 *
 * Columns in table "{{homens_hora}}" available as properties of the model,
 * followed by relations of table "{{homens_hora}}" available as properties of the model.
 *
 * @property string $id
 * @property integer $valor_exercicio
 * @property integer $valor_exercicio_tabela
 * @property integer $usuario_fk
 * @property integer $valor_horas_homem
 * @property integer $valor_ferias
 * @property integer $valor_lic_premio
 * @property integer $valor_outros
 *
 * @property mixed $usuarioFk
 */
abstract class BaseHomensHora extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return '{{homens_hora}}';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'Homens Hora|Homens Hora', $n);
	}

	public static function representingColumn() {
		return 'id';
	}

	public function rules() {
		return array(
			array('valor_exercicio, usuario_fk, valor_horas_homem, valor_ferias', 'required'),
                        array('valor_lic_premio, valor_outros, valor_asterisco','safe'),
			array('valor_exercicio, usuario_fk, valor_horas_homem, valor_ferias, valor_lic_premio, valor_outros', 'numerical', 'integerOnly'=>true),
			array('id, valor_exercicio, valor_asterisco, usuario_fk, valor_horas_homem, valor_ferias, valor_lic_premio, valor_outros', 'safe', 'on'=>'search'),
		);
	}

	public function relations() {
		return array(
			'usuarioFk' => array(self::BELONGS_TO, 'Usuario', 'usuario_fk'),
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'id' => Yii::t('app', 'ID'),
			'valor_exercicio' => Yii::t('app', 'Valor Exercicio'),
			'valor_exercicio_tabela' => Yii::t('app', 'Valor Exercicio Tabela'),
			'usuario_fk' => null,
			'valor_horas_homem' => Yii::t('app', 'Valor Horas Homem'),
			'valor_ferias' => Yii::t('app', 'Valor Ferias'),
			'valor_lic_premio' => Yii::t('app', 'Valor Lic Premio'),
			'valor_outros' => Yii::t('app', 'Valor Outros'),
			'usuarioFk' => null,
		);
	}

	public function search() {
		$criteria = new CDbCriteria;
		
		$criteria->with= array('usuarioFk');		
		
		$sort = new CSort;
		$sort->attributes = array(
				'usuarioFk'=>array(
						'asc'=>'"usuarioFk".nome_usuario',
						'desc'=>'"usuarioFk".nome_usuario desc',
				),
				'valor_exercicio' => 'valor_exercicio',
				'valor_horas_homem' => 'valor_horas_homem',
				'valor_ferias' => 'valor_ferias',
				'valor_lic_premio' => 'valor_lic_premio',
				'valor_outros' => 'valor_outros',
		);
		$sort->defaultOrder = '"usuarioFk".nome_usuario';		
		
		
		$criteria->compare('id', $this->id, true);
		$criteria->compare('valor_exercicio', $this->valor_exercicio);
		$criteria->compare('valor_asterisco', $this->valor_asterisco);
		$criteria->compare('usuario_fk', $this->usuario_fk);
		$criteria->compare('valor_horas_homem', $this->valor_horas_homem);
		$criteria->compare('valor_ferias', $this->valor_ferias);
		$criteria->compare('valor_lic_premio', $this->valor_lic_premio);
		$criteria->compare('valor_outros', $this->valor_outros);
		
		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
			'sort'=>$sort,
		));
	}
}