<?php
/********************************************************************************
*  Copyright 2015 Conab - Companhia Nacional de Abastecimento                   *
*                                                                               *
*  Este arquivo  parte do Sistema SIAUDI.                                      *
*                                                                               *
*  SIAUDI   um software livre; voc pode redistribui-lo e/ou                   *
*  modific-lo sob os termos da Licena Pblica Geral GNU conforme              *
*  publicada pela Free Software Foundation; tanto a verso 2 da                 *
*  Licena, como (a seu critrio) qualquer verso posterior.                    *
*                                                                               *
*  SIAUDI  distribudo na expectativa de que seja til,                        *
*  porm, SEM NENHUMA GARANTIA; nem mesmo a garantia implcita                  *
*  de COMERCIABILIDADE OU ADEQUAO A UMA FINALIDADE ESPECFICA.                *
*  Consulte a Licena Pblica Geral do GNU para mais detalhes em portugus:     *
*  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt                     *
*                                                                               *
*  Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU             *
*  junto com este programa; se no, escreva para a Free Software                *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*                                                                               *
*  Sistema   : SIAUDI - Sistema de Auditoria Interna                            *
*  Data      : 05/2015                                                          *
*                                                                               *
********************************************************************************/
?>
<?php

/**
 * This is the model base class for the table "{{item}}".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "Item".
 *
 * Columns in table "{{item}}" available as properties of the model,
 * followed by relations of table "{{item}}" available as properties of the model.
 *
 * @property string $id
 * @property string $capitulo_fk
 * @property string $numero_item
 * @property string $nome_item
 * @property string $descricao_item
 * @property string $data_gravacao
 * @property string $valor_reais
 * @property boolean $valor_nao_se_aplica
 * @property mixed $capituloFk
 */
abstract class BaseItem extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return '{{item}}';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'Item|Itens', $n);
	}

	public static function representingColumn() {
		return 'nome_item';
	}

	public function rules() {
		return array(
			array('capitulo_fk, nome_item, objeto_fk ', 'required'),
			array('nome_item', 'length', 'max'=>100),
			array('numero_item, descricao_item, data_gravacao,objeto_fk, valor_nao_se_aplica', 'safe'),
			array('capitulo_fk, numero_item', 'numerical', 'integerOnly'=>true),
			array('valor_reais', 'validaValor'),
			array('id, capitulo_fk, numero_item, nome_item, descricao_item, data_gravacao, valor_reais,especie_auditoria_fk, categoria_fk, diretoria_fk, unidade_administrativa_fk,numero_capitulo,relatorio_fk', 'safe', 'on'=>'search'),
		);
	}

	public function validaValor(){
		if ((!$this->valor_reais) && (!$this->valor_nao_se_aplica)){
			$this->addError("valor_reais", "Favor informe o valor ou selecione a opo 'No se aplica'");
		}
	}
	
	
	public function relations() {
		return array(
			'capituloFk' => array(self::BELONGS_TO, 'Capitulo', 'capitulo_fk'),
                        'relatorioFk' => array(self::BELONGS_TO, 'Relatorio', 'relatorio_fk'),                    
                        'objetoFk' => array(self::BELONGS_TO, 'Objeto', 'objeto_fk'),
			'recomendacaoFk' => array(self::HAS_MANY, 'Recomendacao', 'item_fk'),
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'id' => Yii::t('app', 'ID'),
			'capitulo_fk' => null,
			'numero_item' => Yii::t('app', 'Numero Item'),
			'nome_item' => Yii::t('app', 'Nome Item'),
			'descricao_item' => Yii::t('app', 'Descricao Item'),
			'data_gravacao' => Yii::t('app', 'Data Gravacao'),
			'valor_reais' => Yii::t('app', 'Valor Reais'),
                        'objeto_fk' => null,
                        'objetoFk' => null,
			'capituloFk' => null,
		);
	}

        /*
	public function search() {
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id, true);
		$criteria->compare('capitulo_fk', $this->capitulo_fk);
		$criteria->compare('numero_item', $this->numero_item, true);
		$criteria->compare('nome_item', $this->nome_item, true);
		$criteria->compare('descricao_item', $this->descricao_item, true);
		$criteria->compare('data_gravacao', $this->data_gravacao, true);
		$criteria->compare('valor_reais', $this->valor_reais, true);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}*/
}