<?php
/********************************************************************************
*  Copyright 2015 Conab - Companhia Nacional de Abastecimento                   *
*                                                                               *
*  Este arquivo  parte do Sistema SIAUDI.                                      *
*                                                                               *
*  SIAUDI   um software livre; voc pode redistribui-lo e/ou                   *
*  modific-lo sob os termos da Licena Pblica Geral GNU conforme              *
*  publicada pela Free Software Foundation; tanto a verso 2 da                 *
*  Licena, como (a seu critrio) qualquer verso posterior.                    *
*                                                                               *
*  SIAUDI  distribudo na expectativa de que seja til,                        *
*  porm, SEM NENHUMA GARANTIA; nem mesmo a garantia implcita                  *
*  de COMERCIABILIDADE OU ADEQUAO A UMA FINALIDADE ESPECFICA.                *
*  Consulte a Licena Pblica Geral do GNU para mais detalhes em portugus:     *
*  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt                     *
*                                                                               *
*  Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU             *
*  junto com este programa; se no, escreva para a Free Software                *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*                                                                               *
*  Sistema   : SIAUDI - Sistema de Auditoria Interna                            *
*  Data      : 05/2015                                                          *
*                                                                               *
********************************************************************************/
?>
<?php

/**
 * This is the model base class for the table "{{manifestacao}}".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "Manifestacao".
 *
 * Columns in table "{{manifestacao}}" available as properties of the model,
 * followed by relations of table "{{manifestacao}}" available as properties of the model.
 *
 * @property string $id
 * @property string $relatorio_fk
 * @property string $nome_login
 * @property string $data_manifestacao
 * @property string $descricao_manifestacao
 * @property integer $status_manifestacao
 * @property string $descricao_resposta
 * @property string $data_resposta
 * @property string $unidade_administrativa_fk
 *
 * @property mixed $relatorioFk
 */
abstract class BaseManifestacao extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return '{{manifestacao}}';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'Manifestao|Manifestaes', $n);
	}

	public static function representingColumn() {
		return 'data_manifestacao';
	}

	public function rules() {
		return array(
			array('relatorio_fk, nome_login, data_manifestacao', 'required'),
			array('status_manifestacao', 'numerical', 'integerOnly'=>true),
			array('descricao_manifestacao, descricao_resposta, data_resposta, unidade_administrativa_fk, nome_login_resposta', 'safe'),
			array('relatorio_fk, status_manifestacao, unidade_administrativa_fk', 'numerical', 'integerOnly'=>true),
			array('id, relatorio_fk, nome_login, data_manifestacao, descricao_manifestacao, status_manifestacao, descricao_resposta, data_resposta, unidade_administrativa_fk', 'safe', 'on'=>'search'),
		);
	}

	public function relations() {
		return array(
			'relatorioFk' => array(self::BELONGS_TO, 'Relatorio', 'relatorio_fk'),
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'id' => Yii::t('app', 'ID'),
			'relatorio_fk' => null,
			'nome_login' => Yii::t('app', 'Id Usuario Log'),
			'data_manifestacao' => Yii::t('app', 'Data Manifestacao'),
			'descricao_manifestacao' => Yii::t('app', 'Descricao Manifestacao'),
			'status_manifestacao' => Yii::t('app', 'Status Manifestacao'),
			'descricao_resposta' => Yii::t('app', 'Descricao Resposta'),
			'data_resposta' => Yii::t('app', 'Data Resposta'),
			'unidade_administrativa_fk' => Yii::t('app', 'Unidade Administrativa Fk'),
			'relatorioFk' => null,
                        'nome_login_resposta' => null,
		);
	}

	public function search() {
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id, true);
		$criteria->compare('relatorio_fk', $this->relatorio_fk);
		$criteria->compare('nome_login', $this->nome_login, true);
		$criteria->compare('data_manifestacao', $this->data_manifestacao, true);
		$criteria->compare('descricao_manifestacao', $this->descricao_manifestacao, true);
		$criteria->compare('status_manifestacao', $this->status_manifestacao);
		$criteria->compare('descricao_resposta', $this->descricao_resposta, true);
		$criteria->compare('data_resposta', $this->data_resposta, true);
		$criteria->compare('unidade_administrativa_fk', $this->unidade_administrativa_fk, true);
                $criteria->compare('nome_login_resposta', $this->nome_login_resposta, true);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}
}