<?php
/********************************************************************************
*  Copyright 2015 Conab - Companhia Nacional de Abastecimento                   *
*                                                                               *
*  Este arquivo  parte do Sistema SIAUDI.                                      *
*                                                                               *
*  SIAUDI   um software livre; voc pode redistribui-lo e/ou                   *
*  modific-lo sob os termos da Licena Pblica Geral GNU conforme              *
*  publicada pela Free Software Foundation; tanto a verso 2 da                 *
*  Licena, como (a seu critrio) qualquer verso posterior.                    *
*                                                                               *
*  SIAUDI  distribudo na expectativa de que seja til,                        *
*  porm, SEM NENHUMA GARANTIA; nem mesmo a garantia implcita                  *
*  de COMERCIABILIDADE OU ADEQUAO A UMA FINALIDADE ESPECFICA.                *
*  Consulte a Licena Pblica Geral do GNU para mais detalhes em portugus:     *
*  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt                     *
*                                                                               *
*  Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU             *
*  junto com este programa; se no, escreva para a Free Software                *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*                                                                               *
*  Sistema   : SIAUDI - Sistema de Auditoria Interna                            *
*  Data      : 05/2015                                                          *
*                                                                               *
********************************************************************************/
?>
<?php

/**
 * This is the model base class for the table "{{plan_especifico}}".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "PlanEspecifico".
 *
 * Columns in table "{{plan_especifico}}" available as properties of the model,
 * followed by relations of table "{{plan_especifico}}" available as properties of the model.
 *
 * @property string $id
 * @property string $valor_amostra_sureg
 * @property integer $valor_exercicio
 * @property string $observacao_representatividade
 * @property string $observacao_amostragem
 * @property string $data_log
 * @property string $id_usuario_log
 * @property string $valor_sureg
 * @property string $escopo_acao
 * @property string $observacao_questoes_macro
 * @property string $observacao_resultados
 * @property string $observacao_legislacao
 * @property string $observacao_detalhamento
 * @property string $observacao_tecnicas_auditoria
 * @property string $observacao_pendencias
 * @property string $observacao_custos
 * @property string $observacao_cronograma
 * @property string $acao_fk
 *
 * @property mixed $acaoFk
 */
abstract class BasePlanEspecifico extends GxActiveRecord {

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function tableName() {
        return '{{plan_especifico}}';
    }

    public static function label($n = 1) {
        return Yii::t('app', 'Planejamento Especfico|Planejamentos Especficos', $n);
    }

    public static function representingColumn() {
        return 'acao_fk';		 
    }

    public function rules() {
        return array(
            array('valor_exercicio, observacao_representatividade, observacao_amostragem, data_log, id_usuario_log, acao_fk, objeto_fk, data_inicio_atividade, escopo_acao', 'required'),
            array('valor_exercicio', 'numerical', 'integerOnly' => true),
            array('observacao_questoes_macro, observacao_resultados, observacao_legislacao, observacao_detalhamento, observacao_tecnicas_auditoria, observacao_pendencias, observacao_custos, observacao_cronograma, acao_fk, unidade_administrativa_fk, objeto_fk, data_inicio_atividade, escopo_acao', 'safe'),
            array('id_usuario_log, valor_sureg, acao_fk', 'numerical', 'integerOnly' => true),
            array('id, valor_exercicio, observacao_representatividade, observacao_amostragem, data_log, id_usuario_log, valor_sureg, observacao_questoes_macro, observacao_resultados, observacao_legislacao, observacao_detalhamento, observacao_tecnicas_auditoria, observacao_pendencias, observacao_custos, observacao_cronograma, acao_fk, data_inicio_atividade, escopo_acao', 'safe', 'on' => 'search'),
        );
    }

    public function relations() {
        return array(
            'acaoFk' => array(self::BELONGS_TO, 'Acao', 'acao_fk'),
            'valorSureg' => array(self::BELONGS_TO, 'Sureg', 'valor_sureg'),
            'unidadeAdministrativaFK' => array(self::BELONGS_TO, 'UnidadeAdministrativa', 'unidade_administrativa_fk'),
            'objetoFk' => array(self::BELONGS_TO, 'Objeto', 'objeto_fk'),
        );
    }

    public function pivotModels() {
        return array(
        );
    }

    public function attributeLabels() {
        return array(
            'id' => Yii::t('app', 'ID'),
            'valor_exercicio' => Yii::t('app', 'Valor Exercicio'),
            'observacao_representatividade' => Yii::t('app', 'Observacao Representatividade'),
            'observacao_amostragem' => Yii::t('app', 'Observacao Amostragem'),
            'data_log' => Yii::t('app', 'Data Log'),
            'id_usuario_log' => Yii::t('app', 'Id Usuario Log'),
            'valor_sureg' => Yii::t('app', 'Valor Unidade Regional'),
        	'escopo_acao' => Yii::t('app', 'Escopo da Ao'),
            'observacao_questoes_macro' => Yii::t('app', 'Observacao Questoes Macro'),
            'observacao_resultados' => Yii::t('app', 'Observacao Resultados'),
            'observacao_legislacao' => Yii::t('app', 'Observacao Legislacao'),
            'observacao_detalhamento' => Yii::t('app', 'Observacao Detalhamento'),
            'observacao_tecnicas_auditoria' => Yii::t('app', 'Observacao Tecnicas Auditoria'),
            'observacao_pendencias' => Yii::t('app', 'Observacao Pendencias'),
            'observacao_custos' => Yii::t('app', 'Observacao Custos'),
            'observacao_cronograma' => Yii::t('app', 'Observacao Cronograma'),
            'data_inicio_atividade' => Yii::t('app', 'Data Incio Atividades'),
            'acao_fk' => null,
            'acaoFk' => null,
            'objeto_fk' => null,
            'objetoFk' => null,
        );
    }

    public function search() {
        $criteria = new CDbCriteria;
        $criteria->compare('id', $this->id, true);
        $criteria->compare('valor_exercicio', $this->valor_exercicio);
        $criteria->compare('observacao_representatividade', $this->observacao_representatividade, true);
        $criteria->compare('observacao_amostragem', $this->observacao_amostragem, true);
        $criteria->compare('data_log', $this->data_log, true);
        $criteria->compare('id_usuario_log', $this->id_usuario_log, true);
        $criteria->compare('valor_sureg', $this->valor_sureg, true);
        $criteria->compare('observacao_questoes_macro', $this->observacao_questoes_macro, true);
        $criteria->compare('observacao_resultados', $this->observacao_resultados, true);
        $criteria->compare('observacao_legislacao', $this->observacao_legislacao, true);
        $criteria->compare('observacao_detalhamento', $this->observacao_detalhamento, true);
        $criteria->compare('observacao_tecnicas_auditoria', $this->observacao_tecnicas_auditoria, true);
        $criteria->compare('observacao_pendencias', $this->observacao_pendencias, true);
        $criteria->compare('observacao_custos', $this->observacao_custos, true);
        $criteria->compare('observacao_cronograma', $this->observacao_cronograma, true);
        $criteria->compare('acao_fk', $this->acao_fk);
        $criteria->compare('unidade_administrativa_fk', $this->unidade_administrativa_fk);
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

}