<?php
/********************************************************************************
*  Copyright 2015 Conab - Companhia Nacional de Abastecimento                   *
*                                                                               *
*  Este arquivo  parte do Sistema SIAUDI.                                      *
*                                                                               *
*  SIAUDI   um software livre; voc pode redistribui-lo e/ou                   *
*  modific-lo sob os termos da Licena Pblica Geral GNU conforme              *
*  publicada pela Free Software Foundation; tanto a verso 2 da                 *
*  Licena, como (a seu critrio) qualquer verso posterior.                    *
*                                                                               *
*  SIAUDI  distribudo na expectativa de que seja til,                        *
*  porm, SEM NENHUMA GARANTIA; nem mesmo a garantia implcita                  *
*  de COMERCIABILIDADE OU ADEQUAO A UMA FINALIDADE ESPECFICA.                *
*  Consulte a Licena Pblica Geral do GNU para mais detalhes em portugus:     *
*  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt                     *
*                                                                               *
*  Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU             *
*  junto com este programa; se no, escreva para a Free Software                *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*                                                                               *
*  Sistema   : SIAUDI - Sistema de Auditoria Interna                            *
*  Data      : 05/2015                                                          *
*                                                                               *
********************************************************************************/
?>
<?php

/**
 * This is the model base class for the table "{{plan_especifico_auditor}}".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "PlanEspecificoAuditor".
 *
 * Columns in table "{{plan_especifico_auditor}}" available as properties of the model,
 * followed by relations of table "{{plan_especifico_auditor}}" available as properties of the model.
 *
 * @property string $plan_especifico_fk
 * @property string $auditor_fk
 *
 * @property mixed $planEspecificoFk
 */
abstract class BasePlanEspecificoAuditor extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return '{{plan_especifico_auditor}}';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'Planejamento Especfico Auditor|Planejamento Especfico Auditores', $n);
	}

	public static function representingColumn() {
		return 'plan_especifico_fk';
	}

	public function rules() {
		return array(
			array('plan_especifico_fk, usuario_fk, plan_auditor', 'required'),
			array('plan_especifico_fk, usuario_fk', 'numerical', 'integerOnly'=>true),
			array('plan_especifico_fk, usuario_fk', 'safe', 'on'=>'search'),
		);
	}

	public function relations() {
		return array(
			'planEspecificoFk' => array(self::BELONGS_TO, 'PlanEspecifico', 'plan_especifico_fk'),
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'plan_especifico_fk' => null,
			'usuario_fk' => Yii::t('app', 'Auditor Fk'),
			'planEspecificoFk' => null,
		);
	}

	public function search() {
		$criteria = new CDbCriteria;

		$criteria->compare('plan_especifico_fk', $this->plan_especifico_fk);
		$criteria->compare('usuario_fk', $this->usuario_fk, true);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}
}