<?php
/********************************************************************************
*  Copyright 2015 Conab - Companhia Nacional de Abastecimento                   *
*                                                                               *
*  Este arquivo  parte do Sistema SIAUDI.                                      *
*                                                                               *
*  SIAUDI   um software livre; voc pode redistribui-lo e/ou                   *
*  modific-lo sob os termos da Licena Pblica Geral GNU conforme              *
*  publicada pela Free Software Foundation; tanto a verso 2 da                 *
*  Licena, como (a seu critrio) qualquer verso posterior.                    *
*                                                                               *
*  SIAUDI  distribudo na expectativa de que seja til,                        *
*  porm, SEM NENHUMA GARANTIA; nem mesmo a garantia implcita                  *
*  de COMERCIABILIDADE OU ADEQUAO A UMA FINALIDADE ESPECFICA.                *
*  Consulte a Licena Pblica Geral do GNU para mais detalhes em portugus:     *
*  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt                     *
*                                                                               *
*  Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU             *
*  junto com este programa; se no, escreva para a Free Software                *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*                                                                               *
*  Sistema   : SIAUDI - Sistema de Auditoria Interna                            *
*  Data      : 05/2015                                                          *
*                                                                               *
********************************************************************************/
?>
<?php

/**
 * This is the model base class for the table "{{processo}}".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "Processo".
 *
 * Columns in table "{{processo}}" available as properties of the model,
 * followed by relations of table "{{processo}}" available as properties of the model.
 *
 * @property integer $id
 * @property string $nome_processo
 * @property integer $tipo_processo_fk
 * @property integer $valor_exercicio
 *
 * @property mixed $tipoProcessoFk
 */
abstract class BaseProcesso extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return '{{processo}}';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'Processo|Processos', $n);
	}

	public static function representingColumn() {
		return 'nome_processo';
	}

	public function rules() {
		return array(
			array('valor_exercicio, nome_processo, tipo_processo_fk, repetir_todo_ano', 'required'),
			array('id, tipo_processo_fk, valor_exercicio', 'numerical', 'integerOnly'=>true),
			array('nome_processo', 'length', 'max'=>200),
			array('id, nome_processo, tipo_processo_fk, valor_exercicio', 'safe', 'on'=>'search'),
		);
	}
        

	public function relations() {
		return array(
			'tipoProcessoFk' => array(self::BELONGS_TO, 'TipoProcesso', 'tipo_processo_fk'),
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'id' => Yii::t('app', 'ID'),
			'nome_processo' => Yii::t('app', 'Nome Processo'),
			'tipo_processo_fk' => null,
			'valor_exercicio' => Yii::t('app', 'Valor Exercicio'),
			'tipoProcessoFk' => null,
		);
	}

	public function search() {
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
                if ($this->nome_processo){
                        $criteria->condition="nome_processo ilike :input";
                        $criteria->params=array(":input"=>"%".$this->nome_processo."%");
                }                
		$criteria->compare('tipo_processo_fk', $this->tipo_processo_fk);
		$criteria->compare('valor_exercicio', $this->valor_exercicio);
                $criteria->order = 'valor_exercicio, nome_processo';
		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}
}