<?php
/********************************************************************************
*  Copyright 2015 Conab - Companhia Nacional de Abastecimento                   *
*                                                                               *
*  Este arquivo  parte do Sistema SIAUDI.                                      *
*                                                                               *
*  SIAUDI   um software livre; voc pode redistribui-lo e/ou                   *
*  modific-lo sob os termos da Licena Pblica Geral GNU conforme              *
*  publicada pela Free Software Foundation; tanto a verso 2 da                 *
*  Licena, como (a seu critrio) qualquer verso posterior.                    *
*                                                                               *
*  SIAUDI  distribudo na expectativa de que seja til,                        *
*  porm, SEM NENHUMA GARANTIA; nem mesmo a garantia implcita                  *
*  de COMERCIABILIDADE OU ADEQUAO A UMA FINALIDADE ESPECFICA.                *
*  Consulte a Licena Pblica Geral do GNU para mais detalhes em portugus:     *
*  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt                     *
*                                                                               *
*  Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU             *
*  junto com este programa; se no, escreva para a Free Software                *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*                                                                               *
*  Sistema   : SIAUDI - Sistema de Auditoria Interna                            *
*  Data      : 05/2015                                                          *
*                                                                               *
********************************************************************************/
?>
<?php

/**
 * This is the model base class for the table "{{recomendacao}}".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "Recomendacao".
 *
 * Columns in table "{{recomendacao}}" available as properties of the model,
 * followed by relations of table "{{recomendacao}}" available as properties of the model.
 *
 * @property string $id
 * @property integer $numero_recomendacao
 * @property string $relatorio_fk
 * @property string $capitulo_fk
 * @property string $item_fk
 * @property string $unidade_administrativa_fk
 * @property integer $recomendacao_tipo_fk
 * @property integer $recomendacao_gravidade_fk
 * @property string $recomendacao_categoria_fk
 * @property string $recomendacao_subcategoria_fk
 * @property string $descricao_recomendacao
 * @property string $data_gravacao
 *
 * @property mixed $recomendacaoSubcategoriaFk
 * @property mixed $recomendacaoCategoriaFk
 * @property mixed $recomendacaoGravidadeFk
 * @property mixed $recomendacaoTipoFk
 * @property mixed $itemFk
 * @property mixed $capituloFk
 * @property mixed $relatorioFk
 */
abstract class BaseRecomendacao extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return '{{recomendacao}}';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'Recomendao|Recomendaes', $n);
	}

	public static function representingColumn() {
		return 'data_gravacao';
	}

	public function rules() {
		return array(
			array('item_fk, unidade_administrativa_fk, recomendacao_tipo_fk, data_gravacao', 'required'),
			array('numero_recomendacao, recomendacao_tipo_fk', 'numerical', 'integerOnly'=>true),
			array('descricao_recomendacao, recomendacao_gravidade_fk, recomendacao_categoria_fk, recomendacao_subcategoria_fk', 'safe'),
			array('numero_recomendacao, relatorio_fk, capitulo_fk, item_fk, unidade_administrativa_fk, recomendacao_tipo_fk', 'numerical', 'integerOnly'=>true),
			array('id, numero_recomendacao, relatorio_fk, capitulo_fk, item_fk, unidade_administrativa_fk, recomendacao_tipo_fk, recomendacao_gravidade_fk, recomendacao_categoria_fk, recomendacao_subcategoria_fk, descricao_recomendacao, data_gravacao,numero_capitulo,especie_auditoria_fk, categoria_fk, diretoria_fk, unidade_administrativa_fk,numero_capitulo,relatorio_fk', 'safe', 'on'=>'search'),
		);
	}

	public function relations() {
		return array(
			'recomendacaoSubcategoriaFk' => array(self::BELONGS_TO, 'RecomendacaoSubcategoria', 'recomendacao_subcategoria_fk'),
			'recomendacaoCategoriaFk' => array(self::BELONGS_TO, 'RecomendacaoCategoria', 'recomendacao_categoria_fk'),
			'recomendacaoGravidadeFk' => array(self::BELONGS_TO, 'RecomendacaoGravidade', 'recomendacao_gravidade_fk'),
			'recomendacaoTipoFk' => array(self::BELONGS_TO, 'RecomendacaoTipo', 'recomendacao_tipo_fk'),
			'itemFk' => array(self::BELONGS_TO, 'Item', 'item_fk'),
			'capituloFk' => array(self::BELONGS_TO, 'Capitulo', 'capitulo_fk'),
			'relatorioFk' => array(self::BELONGS_TO, 'Relatorio', 'relatorio_fk'),
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'id' => Yii::t('app', 'ID'),
			'numero_recomendacao' => Yii::t('app', 'Numero Recomendacao'),
			'relatorio_fk' => null,
			'capitulo_fk' => null,
			'item_fk' => null,
			'unidade_administrativa_fk' => Yii::t('app', 'Unidade Administrativa Fk'),
			'recomendacao_tipo_fk' => null,
			'recomendacao_gravidade_fk' => null,
			'recomendacao_categoria_fk' => null,
			'recomendacao_subcategoria_fk' => null,
			'descricao_recomendacao' => Yii::t('app', 'Descricao Recomendacao'),
			'data_gravacao' => Yii::t('app', 'Data Gravacao'),
			'recomendacaoSubcategoriaFk' => null,
			'recomendacaoCategoriaFk' => null,
			'recomendacaoGravidadeFk' => null,
			'recomendacaoTipoFk' => null,
			'itemFk' => null,
			'capituloFk' => null,
			'relatorioFk' => null,
		);
	}

	public function search() {
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id, true);
		$criteria->compare('numero_recomendacao', $this->numero_recomendacao);
		$criteria->compare('relatorio_fk', $this->relatorio_fk);
		$criteria->compare('capitulo_fk', $this->capitulo_fk);
		$criteria->compare('item_fk', $this->item_fk);
		$criteria->compare('unidade_administrativa_fk', $this->unidade_administrativa_fk, true);
		$criteria->compare('recomendacao_tipo_fk', $this->recomendacao_tipo_fk);
		$criteria->compare('recomendacao_gravidade_fk', $this->recomendacao_gravidade_fk);
		$criteria->compare('recomendacao_categoria_fk', $this->recomendacao_categoria_fk);
		$criteria->compare('recomendacao_subcategoria_fk', $this->recomendacao_subcategoria_fk);
		$criteria->compare('descricao_recomendacao', $this->descricao_recomendacao, true);
		$criteria->compare('data_gravacao', $this->data_gravacao, true);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}
}