<?php
/********************************************************************************
*  Copyright 2015 Conab - Companhia Nacional de Abastecimento                   *
*                                                                               *
*  Este arquivo  parte do Sistema SIAUDI.                                      *
*                                                                               *
*  SIAUDI   um software livre; voc pode redistribui-lo e/ou                   *
*  modific-lo sob os termos da Licena Pblica Geral GNU conforme              *
*  publicada pela Free Software Foundation; tanto a verso 2 da                 *
*  Licena, como (a seu critrio) qualquer verso posterior.                    *
*                                                                               *
*  SIAUDI  distribudo na expectativa de que seja til,                        *
*  porm, SEM NENHUMA GARANTIA; nem mesmo a garantia implcita                  *
*  de COMERCIABILIDADE OU ADEQUAO A UMA FINALIDADE ESPECFICA.                *
*  Consulte a Licena Pblica Geral do GNU para mais detalhes em portugus:     *
*  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt                     *
*                                                                               *
*  Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU             *
*  junto com este programa; se no, escreva para a Free Software                *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*                                                                               *
*  Sistema   : SIAUDI - Sistema de Auditoria Interna                            *
*  Data      : 05/2015                                                          *
*                                                                               *
********************************************************************************/
?>
<?php

/**
 * This is the model base class for the table "{{recomendacao_subcategoria}}".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "RecomendacaoSubcategoria".
 *
 * Columns in table "{{recomendacao_subcategoria}}" available as properties of the model,
 * followed by relations of table "{{recomendacao_subcategoria}}" available as properties of the model.
 *
 * @property integer $id
 * @property integer $recomendacao_categoria_fk
 * @property string $nome_subcategoria
 *
 * @property mixed $recomendacaoCategoriaFk
 */
abstract class BaseRecomendacaoSubcategoria extends GxActiveRecord {

	public static function model($className = __CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return '{{recomendacao_subcategoria}}';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'Subcategoria da Recomendao|Subcategorias da Recomendao', $n);
	}

	public static function representingColumn() {
		return 'nome_subcategoria';
	}

	public function rules() {
		return array(
		array('recomendacao_categoria_fk, nome_subcategoria', 'required'),
		array('recomendacao_categoria_fk', 'numerical', 'integerOnly' => true),
		array('nome_subcategoria', 'length', 'max' => 200),
		array('id, recomendacao_categoria_fk, nome_subcategoria', 'safe', 'on' => 'search'),
		);
	}

	public function relations() {
		return array(
            'recomendacaoCategoriaFk' => array(self::BELONGS_TO, 'RecomendacaoCategoria', 'recomendacao_categoria_fk'),
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
            'id' => Yii::t('app', 'ID'),
            'recomendacao_categoria_fk' => null,
            'nome_subcategoria' => Yii::t('app', 'Nome Subcategoria'),
            'recomendacaoCategoriaFk' => null,
		);
	}

    public function search() {
        $schema = Yii::app()->params['schema'];        
        $criteria = new CDbCriteria;
        
        $criteria->alias = "t";
        $criteria->compare('id', $this->id);
        $criteria->compare('recomendacao_categoria_fk', $this->recomendacao_categoria_fk);
        $criteria->compare('nome_subcategoria', $this->nome_subcategoria, true);
        
        $criteria->join = "LEFT JOIN {$schema}.tb_recomendacao_categoria categoria ON t.recomendacao_categoria_fk=categoria.id";
        $criteria->order='categoria.nome_categoria, t.nome_subcategoria';


		return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
		));
	}

}