<?php
/********************************************************************************
*  Copyright 2015 Conab - Companhia Nacional de Abastecimento                   *
*                                                                               *
*  Este arquivo  parte do Sistema SIAUDI.                                      *
*                                                                               *
*  SIAUDI   um software livre; voc pode redistribui-lo e/ou                   *
*  modific-lo sob os termos da Licena Pblica Geral GNU conforme              *
*  publicada pela Free Software Foundation; tanto a verso 2 da                 *
*  Licena, como (a seu critrio) qualquer verso posterior.                    *
*                                                                               *
*  SIAUDI  distribudo na expectativa de que seja til,                        *
*  porm, SEM NENHUMA GARANTIA; nem mesmo a garantia implcita                  *
*  de COMERCIABILIDADE OU ADEQUAO A UMA FINALIDADE ESPECFICA.                *
*  Consulte a Licena Pblica Geral do GNU para mais detalhes em portugus:     *
*  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt                     *
*                                                                               *
*  Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU             *
*  junto com este programa; se no, escreva para a Free Software                *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*                                                                               *
*  Sistema   : SIAUDI - Sistema de Auditoria Interna                            *
*  Data      : 05/2015                                                          *
*                                                                               *
********************************************************************************/
?>
<?php

/**
 * This is the model base class for the table "{{relatorio_sureg}}".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "RelatorioSureg".
 *
 * Columns in table "{{relatorio_sureg}}" available as properties of the model,
 * followed by relations of table "{{relatorio_sureg}}" available as properties of the model.
 *
 * @property string $relatorio_fk
 * @property string $unidade_administrativa_fk
 * @property boolean $sureg_secundaria
 *
 * @property mixed $relatorioFk
 */
abstract class BaseRelatorioSureg extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return '{{relatorio_sureg}}';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'RelatorioSureg|RelatorioSuregs', $n);
	}

	public static function representingColumn() {
		return 'relatorio_fk';
	}

	public function rules() {
		return array(
			array('relatorio_fk, unidade_administrativa_fk, sureg_secundaria', 'required'),
			array('relatorio_fk, unidade_administrativa_fk', 'numerical', 'integerOnly'=>true),
			array('relatorio_fk, unidade_administrativa_fk', 'safe', 'on'=>'search'),
		);
	}

	public function relations() {
		return array(
			'relatorioFk' => array(self::BELONGS_TO, 'Siaudi.relatorio', 'relatorio_fk'),
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'relatorio_fk' => null,
			'unidade_administrativa_fk' => Yii::t('app', 'Unidade Administrativa Fk'),
			'relatorioFk' => null,
		);
	}

	public function search() {
		$criteria = new CDbCriteria;

		$criteria->compare('relatorio_fk', $this->relatorio_fk);
		$criteria->compare('unidade_administrativa_fk', $this->unidade_administrativa_fk, true);
		$criteria->compare('sureg_secundaria', $this->sureg_secundaria);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}
}