<?php
/********************************************************************************
*  Copyright 2015 Conab - Companhia Nacional de Abastecimento                   *
*                                                                               *
*  Este arquivo  parte do Sistema SIAUDI.                                      *
*                                                                               *
*  SIAUDI   um software livre; voc pode redistribui-lo e/ou                   *
*  modific-lo sob os termos da Licena Pblica Geral GNU conforme              *
*  publicada pela Free Software Foundation; tanto a verso 2 da                 *
*  Licena, como (a seu critrio) qualquer verso posterior.                    *
*                                                                               *
*  SIAUDI  distribudo na expectativa de que seja til,                        *
*  porm, SEM NENHUMA GARANTIA; nem mesmo a garantia implcita                  *
*  de COMERCIABILIDADE OU ADEQUAO A UMA FINALIDADE ESPECFICA.                *
*  Consulte a Licena Pblica Geral do GNU para mais detalhes em portugus:     *
*  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt                     *
*                                                                               *
*  Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU             *
*  junto com este programa; se no, escreva para a Free Software                *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*                                                                               *
*  Sistema   : SIAUDI - Sistema de Auditoria Interna                            *
*  Data      : 05/2015                                                          *
*                                                                               *
********************************************************************************/
?>
<?php

/**
 * This is the model base class for the table "{{risco}}".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "Risco".
 *
 * Columns in table "{{risco}}" available as properties of the model,
 * followed by relations of table "{{risco}}" available as properties of the model.
 *
 * @property string $id
 * @property string $acao_fk
 * @property string $criterio_fk
 * @property integer $numero_nota
 * @property string $data_log
 * @property string $id_usuario_log
 *
 * @property mixed $acaoFk
 * @property mixed $criterioFk
*/

abstract class BaseRisco extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return '{{subrisco}}';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'Risco|Riscos', $n);
	}

	public static function representingColumn() {
		return 'data_log';
	}

	public function rules() {
		return array(
			array('processo_fk, criterio_fk, numero_nota, data_log, id_usuario_log ', 'required'),
			array('numero_nota', 'numerical', 'integerOnly'=>true),
			array('processo_fk, criterio_fk, numero_nota, id_usuario_log', 'numerical', 'integerOnly'=>true),
			array('id, processo_fk, criterio_fk, numero_nota, data_log, id_usuario_log', 'safe', 'on'=>'search'),
		);
	}

	public function relations() {
		return array(
			'processoFk' => array(self::BELONGS_TO, 'Processo', 'processo_fk'),
			'criterioFk' => array(self::BELONGS_TO, 'Criterio', 'criterio_fk'),
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'id' => Yii::t('app', 'ID'),
			'criterio_fk' => null,
			'numero_nota' => Yii::t('app', 'Numero Nota'),
			'data_log' => Yii::t('app', 'Data Log'),
			'id_usuario_log' => Yii::t('app', 'Id Usuario Log'),
			'acaoFk' => null,
			'criterioFk' => null,
			'processoFk' => null,                    
			'processo_Fk' => null,                    
		);
	}

/*	public function search() {
		$criteria = new CDbCriteria;
		$criteria->compare('id', $this->id, true);
		$criteria->compare('acao_fk', $this->acao_fk);
		$criteria->compare('criterio_fk', $this->criterio_fk);
		$criteria->compare('numero_nota', $this->numero_nota);
		$criteria->compare('data_log', $this->data_log, true);
		$criteria->compare('id_usuario_log', $this->id_usuario_log, true);
		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}*/
}