<?php
/********************************************************************************
*  Copyright 2015 Conab - Companhia Nacional de Abastecimento                   *
*                                                                               *
*  Este arquivo  parte do Sistema SIAUDI.                                      *
*                                                                               *
*  SIAUDI   um software livre; voc pode redistribui-lo e/ou                   *
*  modific-lo sob os termos da Licena Pblica Geral GNU conforme              *
*  publicada pela Free Software Foundation; tanto a verso 2 da                 *
*  Licena, como (a seu critrio) qualquer verso posterior.                    *
*                                                                               *
*  SIAUDI  distribudo na expectativa de que seja til,                        *
*  porm, SEM NENHUMA GARANTIA; nem mesmo a garantia implcita                  *
*  de COMERCIABILIDADE OU ADEQUAO A UMA FINALIDADE ESPECFICA.                *
*  Consulte a Licena Pblica Geral do GNU para mais detalhes em portugus:     *
*  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt                     *
*                                                                               *
*  Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU             *
*  junto com este programa; se no, escreva para a Free Software                *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*                                                                               *
*  Sistema   : SIAUDI - Sistema de Auditoria Interna                            *
*  Data      : 05/2015                                                          *
*                                                                               *
********************************************************************************/
?>
<?php

/**
 * This is the model base class for the table "{{risco_pos}}".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "RiscoPos".
 *
 * Columns in table "{{risco_pos}}" available as properties of the model,
 * and there are no model relations.
 *
 * @property string $id
 * @property string $descricao_impacto
 * @property string $nome_risco
 * @property string $descricao_mitigacao
 *
 */
abstract class BaseRiscoPos extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return '{{risco_pos}}';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'Risco Ps Identificado|Riscos Ps Identificados', $n);
	}

	public static function representingColumn() {
		return 'descricao_impacto';
	}

	public function rules() {
		return array(
                        array('nome_risco', 'required'),                    
			array('descricao_impacto, descricao_mitigacao', 'safe'),
			array('id, descricao_impacto, nome_risco, descricao_mitigacao', 'safe', 'on'=>'search'),
		);
	}

	public function relations() {
		return array(
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'id' => Yii::t('app', 'ID'),
			'descricao_impacto' => Yii::t('app', 'Descricao Impacto'),
			'nome_risco' => Yii::t('app', 'Nome Risco'),
			'descricao_mitigacao' => Yii::t('app', 'Descricao Mitigacao'),
		);
	}

	public function search() {
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id, true);
		$criteria->compare('descricao_impacto', $this->descricao_impacto, true);
		$criteria->compare('nome_risco', $this->nome_risco, true);
		$criteria->compare('descricao_mitigacao', $this->descricao_mitigacao, true);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}
}