<?php
/********************************************************************************
*  Copyright 2015 Conab - Companhia Nacional de Abastecimento                   *
*                                                                               *
*  Este arquivo  parte do Sistema SIAUDI.                                      *
*                                                                               *
*  SIAUDI   um software livre; voc pode redistribui-lo e/ou                   *
*  modific-lo sob os termos da Licena Pblica Geral GNU conforme              *
*  publicada pela Free Software Foundation; tanto a verso 2 da                 *
*  Licena, como (a seu critrio) qualquer verso posterior.                    *
*                                                                               *
*  SIAUDI  distribudo na expectativa de que seja til,                        *
*  porm, SEM NENHUMA GARANTIA; nem mesmo a garantia implcita                  *
*  de COMERCIABILIDADE OU ADEQUAO A UMA FINALIDADE ESPECFICA.                *
*  Consulte a Licena Pblica Geral do GNU para mais detalhes em portugus:     *
*  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt                     *
*                                                                               *
*  Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU             *
*  junto com este programa; se no, escreva para a Free Software                *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*                                                                               *
*  Sistema   : SIAUDI - Sistema de Auditoria Interna                            *
*  Data      : 05/2015                                                          *
*                                                                               *
********************************************************************************/
?>
<?php

/**
 * This is the model base class for the table "{{subrisco}}".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "Subrisco".
 *
 * Columns in table "{{subrisco}}" available as properties of the model,
 * followed by relations of table "{{subrisco}}" available as properties of the model.
 *
 * @property string $id
 * @property integer $subcriterio_fk
 * @property integer $processo_fk
 * @property integer $numero_nota
 * @property string $data_log
 * @property string $id_usuario
 *
 * @property mixed $processoFk
 * @property mixed $subcriterioFk
 */
abstract class BaseSubrisco extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return '{{subrisco}}';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'Sub-risco|Sub-riscos', $n);
	}

	public static function representingColumn() {
		return 'data_log';
	}

	public function rules() {
		return array(
			array('subcriterio_fk, processo_fk, numero_nota, data_log, id_usuario, valor_exercicio', 'required'),
			array('subcriterio_fk, processo_fk, numero_nota', 'numerical', 'integerOnly'=>true),
			array('numero_nota, id_usuario', 'numerical', 'integerOnly'=>true),
			array('id, subcriterio_fk, processo_fk, numero_nota, data_log, id_usuario', 'safe', 'on'=>'search'),
		);
	}

	public function relations() {
		return array(
			'processoFk' => array(self::BELONGS_TO, 'processo', 'processo_fk'),
			'subcriterioFk' => array(self::BELONGS_TO, 'subcriterio', 'subcriterio_fk'),
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'id' => Yii::t('app', 'ID'),
			'subcriterio_fk' => null,
			'processo_fk' => null,
			'numero_nota' => Yii::t('app', 'Numero Nota'),
			'data_log' => Yii::t('app', 'Data Log'),
			'id_usuario' => Yii::t('app', 'Id Usuario'),
			'processoFk' => null,
			'subcriterioFk' => null,
		);
	}

	public function search() {
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id, true);
		$criteria->compare('subcriterio_fk', $this->subcriterio_fk);
		$criteria->compare('processo_fk', $this->processo_fk);
		$criteria->compare('numero_nota', $this->numero_nota);
		$criteria->compare('data_log', $this->data_log, true);
		$criteria->compare('id_usuario', $this->id_usuario, true);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}
}