<?php
/********************************************************************************
*  Copyright 2015 Conab - Companhia Nacional de Abastecimento                   *
*                                                                               *
*  Este arquivo  parte do Sistema SIAUDI.                                      *
*                                                                               *
*  SIAUDI   um software livre; voc pode redistribui-lo e/ou                   *
*  modific-lo sob os termos da Licena Pblica Geral GNU conforme              *
*  publicada pela Free Software Foundation; tanto a verso 2 da                 *
*  Licena, como (a seu critrio) qualquer verso posterior.                    *
*                                                                               *
*  SIAUDI  distribudo na expectativa de que seja til,                        *
*  porm, SEM NENHUMA GARANTIA; nem mesmo a garantia implcita                  *
*  de COMERCIABILIDADE OU ADEQUAO A UMA FINALIDADE ESPECFICA.                *
*  Consulte a Licena Pblica Geral do GNU para mais detalhes em portugus:     *
*  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt                     *
*                                                                               *
*  Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU             *
*  junto com este programa; se no, escreva para a Free Software                *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*                                                                               *
*  Sistema   : SIAUDI - Sistema de Auditoria Interna                            *
*  Data      : 05/2015                                                          *
*                                                                               *
********************************************************************************/
?>
<?php

/**
 * This is the model base class for the table "{{unidade_administrativa}}".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "UnidadeAdministrativa".
 *
 * Columns in table "{{unidade_administrativa}}" available as properties of the model,
 * followed by relations of table "{{unidade_administrativa}}" available as properties of the model.
 *
 * @property string $id
 * @property string $nome
 * @property string $sigla
 * @property string $uf_fk
 * @property string $subordinante_fk
 * @property string $sureg
 * @property string $diretoria
 *
 * @property UnidadeAdministrativa $subordinanteFk
 * @property UnidadeAdministrativa[] $unidadeAdministrativas
 */
abstract class BaseUnidadeAdministrativa extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return '{{unidade_administrativa}}';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'Unidade Administrativa (Lotao)|Unidade Administrativas (Lotaes)', $n);
	}

	public static function representingColumn() {
		return 'sigla';
	}

	public function rules() {
		return array(
			array('nome, sigla, uf_fk,  sureg, diretoria', 'required'),
			array('nome', 'length', 'max'=>80),
			array('sigla', 'length', 'max'=>20),
			array('uf_fk', 'length', 'max'=>2),
			array('subordinante_fk, sureg, diretoria, data_extincao', 'safe'),
			array('id, subordinante_fk', 'numerical', 'integerOnly'=>true),
			array('id, nome, sigla, uf_fk, subordinante_fk, data_extincao', 'safe', 'on'=>'search'),
		);
	}

	public function relations() {
		return array(
			'subordinanteFk' => array(self::BELONGS_TO, 'UnidadeAdministrativa', 'subordinante_fk'),
			'unidadeAdministrativas' => array(self::HAS_MANY, 'UnidadeAdministrativa', 'subordinante_fk'),
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'id' => Yii::t('app', 'ID'),
			'nome' => Yii::t('app', 'Nome'),
			'sigla' => Yii::t('app', 'Sigla'),
			'uf_fk' => Yii::t('app', 'Uf Fk'),
			'sureg' => Yii::t('app', 'Unidade Regional'),
			'diretoria' => Yii::t('app', 'Diretoria'),
                        'data_extincao' => Yii::t('app', 'Data de extino'),                    
			'subordinante_fk' => null,
			'subordinanteFk' => null,
			'unidadeAdministrativas' => null,
		);
	}

	public function search() {
		$criteria = new CDbCriteria;
		
		$schema = Yii::app()->params['schema'];
        $criteria->alias = "t";
		
		$criteria->compare('t.id', $this->id, true);
		$criteria->compare('t.nome', strtoupper($this->nome), true);
		$criteria->compare('t.sigla', strtoupper($this->sigla), true);
		$criteria->compare('t.uf_fk', $this->uf_fk, true);
		$criteria->compare('t.subordinante_fk', $this->subordinante_fk);
		$criteria->compare('t.sureg', $this->sureg);
		$criteria->compare('t.diretoria', $this->diretoria);
		
        $criteria->join = "LEFT JOIN {$schema}.tb_unidade_administrativa ua ON t.subordinante_fk=ua.id";
        $criteria->order='t.nome, t.sigla, ua.sigla';
		
		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}
}