<?php
/********************************************************************************
*  Copyright 2015 Conab - Companhia Nacional de Abastecimento                   *
*                                                                               *
*  Este arquivo  parte do Sistema SIAUDI.                                      *
*                                                                               *
*  SIAUDI   um software livre; voc pode redistribui-lo e/ou                   *
*  modific-lo sob os termos da Licena Pblica Geral GNU conforme              *
*  publicada pela Free Software Foundation; tanto a verso 2 da                 *
*  Licena, como (a seu critrio) qualquer verso posterior.                    *
*                                                                               *
*  SIAUDI  distribudo na expectativa de que seja til,                        *
*  porm, SEM NENHUMA GARANTIA; nem mesmo a garantia implcita                  *
*  de COMERCIABILIDADE OU ADEQUAO A UMA FINALIDADE ESPECFICA.                *
*  Consulte a Licena Pblica Geral do GNU para mais detalhes em portugus:     *
*  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt                     *
*                                                                               *
*  Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU             *
*  junto com este programa; se no, escreva para a Free Software                *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*                                                                               *
*  Sistema   : SIAUDI - Sistema de Auditoria Interna                            *
*  Data      : 05/2015                                                          *
*                                                                               *
********************************************************************************/
?>
<?php

/**
 * This is the model base class for the table "public.vw_menu".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "VwMenu".
 *
 * Columns in table "public.vw_menu" available as properties of the model,
 * and there are no model relations.
 *
 * @property string $id_sistema
 * @property string $nome_sistema
 * @property string $id
 * @property string $menu_pai_fk
 * @property string $perfil_fk
 * @property integer $nivel
 * @property integer $ordem
 * @property integer $coluna
 * @property string $titulo
 * @property string $descricao
 * @property string $url
 * @property string $imagem
 * @property string $url_parametro
 *
 */
abstract class BaseVwMenu extends GxActiveRecord {

    public static function model($className=__CLASS__) {
        return parent::model($className);
    }

    public function tableName() {
        return 'siaudi.vw_menu';
    }

    public static function label($n = 1) {
        return Yii::t('app', 'VwMenu|VwMenus', $n);
    }

    public static function representingColumn() {
        return 'nome_sistema';
    }

    public function rules() {
        return array(
            array('nivel, ordem, coluna', 'numerical', 'integerOnly' => true),
            array('nome_sistema', 'length', 'max' => 1024),
            array('titulo, descricao', 'length', 'max' => 50),
            array('url, imagem', 'length', 'max' => 100),
            array('url_parametro', 'length', 'max' => 200),
            array('id_sistema, id, menu_pai_fk, perfil_fk', 'safe'),
            array('id_sistema, nome_sistema, id, menu_pai_fk, perfil_fk, nivel, ordem, coluna, titulo, descricao, url, imagem, url_parametro', 'default', 'setOnEmpty' => true, 'value' => null),
            array('id_sistema, nome_sistema, id, menu_pai_fk, perfil_fk, nivel, ordem, coluna, titulo, descricao, url, imagem, url_parametro', 'safe', 'on' => 'search'),
        );
    }

    public function relations() {
        return array(
        );
    }

    public function pivotModels() {
        return array(
        );
    }

    public function attributeLabels() {
        return array(
            'id_sistema' => Yii::t('app', 'Id Sistema'),
            'nome_sistema' => Yii::t('app', 'Nome Sistema'),
            'id' => Yii::t('app', 'ID'),
            'menu_pai_fk' => Yii::t('app', 'Menu Pai Fk'),
            'perfil_fk' => Yii::t('app', 'Perfil Fk'),
            'nivel' => Yii::t('app', 'Nivel'),
            'ordem' => Yii::t('app', 'Ordem'),
            'coluna' => Yii::t('app', 'Coluna'),
            'titulo' => Yii::t('app', 'Titulo'),
            'descricao' => Yii::t('app', 'Descricao'),
            'url' => Yii::t('app', 'Url'),
            'imagem' => Yii::t('app', 'Imagem'),
            'url_parametro' => Yii::t('app', 'Url Parametro'),
        );
    }

    public function search() {
        $criteria = new CDbCriteria;

        $criteria->compare('id_sistema', $this->id_sistema, true);
        $criteria->compare('nome_sistema', $this->nome_sistema, true);
        $criteria->compare('id', $this->id, true);
        $criteria->compare('menu_pai_fk', $this->menu_pai_fk, true);
        $criteria->compare('perfil_fk', $this->perfil_fk, true);
        $criteria->compare('nivel', $this->nivel);
        $criteria->compare('ordem', $this->ordem);
        $criteria->compare('coluna', $this->coluna);
        $criteria->compare('titulo', $this->titulo, true);
        $criteria->compare('descricao', $this->descricao, true);
        $criteria->compare('url', $this->url, true);
        $criteria->compare('imagem', $this->imagem, true);
        $criteria->compare('url_parametro', $this->url_parametro, true);

        return new CActiveDataProvider($this, array(
                    'criteria' => $criteria,
                ));
    }

}