<?php
/********************************************************************************
*  Copyright 2015 Conab - Companhia Nacional de Abastecimento                   *
*                                                                               *
*  Este arquivo  parte do Sistema SIAUDI.                                      *
*                                                                               *
*  SIAUDI   um software livre; voc pode redistribui-lo e/ou                   *
*  modific-lo sob os termos da Licena Pblica Geral GNU conforme              *
*  publicada pela Free Software Foundation; tanto a verso 2 da                 *
*  Licena, como (a seu critrio) qualquer verso posterior.                    *
*                                                                               *
*  SIAUDI  distribudo na expectativa de que seja til,                        *
*  porm, SEM NENHUMA GARANTIA; nem mesmo a garantia implcita                  *
*  de COMERCIABILIDADE OU ADEQUAO A UMA FINALIDADE ESPECFICA.                *
*  Consulte a Licena Pblica Geral do GNU para mais detalhes em portugus:     *
*  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt                     *
*                                                                               *
*  Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU             *
*  junto com este programa; se no, escreva para a Free Software                *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*                                                                               *
*  Sistema   : SIAUDI - Sistema de Auditoria Interna                            *
*  Data      : 05/2015                                                          *
*                                                                               *
********************************************************************************/
?>
<?php

/**
 * This is the model base class for the table "public.vw_restricao".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "VwRestricao".
 *
 * Columns in table "public.vw_restricao" available as properties of the model,
 * and there are no model relations.
 *
 * @property string $id_sistema
 * @property string $nome_sistema
 * @property string $id_perfil
 * @property string $nome_perfil
 * @property string $descricao_perfil
 * @property string $id_modulo
 * @property string $nome_modulo
 * @property string $descricao_modulo
 * @property string $id_restricao
 * @property string $nome_componente
 * @property string $descricao_componente
 * @property string $nome_propriedade
 * @property string $valor_propriedade
 *
 */
abstract class BaseVwRestricao extends GxActiveRecord {

    public static function model($className=__CLASS__) {
        return parent::model($className);
    }

    public function tableName() {
        return 'siaudi.vw_restricao';
    }

    public static function label($n = 1) {
        return Yii::t('app', 'VwRestricao|VwRestricaos', $n);
    }

    public static function representingColumn() {
        return 'nome_sistema';
    }

    public function rules() {
        return array(
            array('nome_sistema, nome_perfil, descricao_perfil', 'length', 'max' => 1024),
            array('nome_modulo', 'length', 'max' => 100),
            array('descricao_modulo, descricao_componente', 'length', 'max' => 250),
            array('nome_componente, nome_propriedade, valor_propriedade', 'length', 'max' => 50),
            array('id_sistema, id_perfil, id_modulo, id_restricao', 'safe'),
            array('id_sistema, nome_sistema, id_perfil, nome_perfil, descricao_perfil, id_modulo, nome_modulo, descricao_modulo, id_restricao, nome_componente, descricao_componente, nome_propriedade, valor_propriedade', 'default', 'setOnEmpty' => true, 'value' => null),
            array('id_sistema, nome_sistema, id_perfil, nome_perfil, descricao_perfil, id_modulo, nome_modulo, descricao_modulo, id_restricao, nome_componente, descricao_componente, nome_propriedade, valor_propriedade', 'safe', 'on' => 'search'),
        );
    }

    public function relations() {
        return array(
        );
    }

    public function pivotModels() {
        return array(
        );
    }

    public function attributeLabels() {
        return array(
            'id_sistema' => Yii::t('app', 'Id Sistema'),
            'nome_sistema' => Yii::t('app', 'Nome Sistema'),
            'id_perfil' => Yii::t('app', 'Id Perfil'),
            'nome_perfil' => Yii::t('app', 'Nome Perfil'),
            'descricao_perfil' => Yii::t('app', 'Descricao Perfil'),
            'id_modulo' => Yii::t('app', 'Id Modulo'),
            'nome_modulo' => Yii::t('app', 'Nome Modulo'),
            'descricao_modulo' => Yii::t('app', 'Descricao Modulo'),
            'id_restricao' => Yii::t('app', 'Id Restricao'),
            'nome_componente' => Yii::t('app', 'Nome Componente'),
            'descricao_componente' => Yii::t('app', 'Descricao Componente'),
            'nome_propriedade' => Yii::t('app', 'Nome Propriedade'),
            'valor_propriedade' => Yii::t('app', 'Valor Propriedade'),
        );
    }

    public function search() {
        $criteria = new CDbCriteria;

        $criteria->compare('id_sistema', $this->id_sistema, true);
        $criteria->compare('nome_sistema', $this->nome_sistema, true);
        $criteria->compare('id_perfil', $this->id_perfil, true);
        $criteria->compare('nome_perfil', $this->nome_perfil, true);
        $criteria->compare('descricao_perfil', $this->descricao_perfil, true);
        $criteria->compare('id_modulo', $this->id_modulo, true);
        $criteria->compare('nome_modulo', $this->nome_modulo, true);
        $criteria->compare('descricao_modulo', $this->descricao_modulo, true);
        $criteria->compare('id_restricao', $this->id_restricao, true);
        $criteria->compare('nome_componente', $this->nome_componente, true);
        $criteria->compare('descricao_componente', $this->descricao_componente, true);
        $criteria->compare('nome_propriedade', $this->nome_propriedade, true);
        $criteria->compare('valor_propriedade', $this->valor_propriedade, true);

        return new CActiveDataProvider($this, array(
                    'criteria' => $criteria,
                ));
    }

}