<?php
/********************************************************************************
*  Copyright 2015 Conab - Companhia Nacional de Abastecimento                   *
*                                                                               *
*  Este arquivo  parte do Sistema SIAUDI.                                      *
*                                                                               *
*  SIAUDI   um software livre; voc pode redistribui-lo e/ou                   *
*  modific-lo sob os termos da Licena Pblica Geral GNU conforme              *
*  publicada pela Free Software Foundation; tanto a verso 2 da                 *
*  Licena, como (a seu critrio) qualquer verso posterior.                    *
*                                                                               *
*  SIAUDI  distribudo na expectativa de que seja til,                        *
*  porm, SEM NENHUMA GARANTIA; nem mesmo a garantia implcita                  *
*  de COMERCIABILIDADE OU ADEQUAO A UMA FINALIDADE ESPECFICA.                *
*  Consulte a Licena Pblica Geral do GNU para mais detalhes em portugus:     *
*  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt                     *
*                                                                               *
*  Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU             *
*  junto com este programa; se no, escreva para a Free Software                *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*                                                                               *
*  Sistema   : SIAUDI - Sistema de Auditoria Interna                            *
*  Data      : 05/2015                                                          *
*                                                                               *
********************************************************************************/
?>
<?php

/**
 * This is the model base class for the table "public.vw_usuario".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "VwUsuario".
 *
 * Columns in table "public.vw_usuario" available as properties of the model,
 * and there are no model relations.
 *
 * @property string $id_usuario
 * @property string $login
 * @property string $funcao
 * @property string $nome_usuario
 * @property string $email
 * @property integer $matricula
 * @property string $situacao
 * @property string $cpf
 * @property string $id_und_adm
 * @property string $nome_und_adm
 * @property string $sigla_und_adm
 * @property string $uf_und_adm
 *
 */
abstract class BaseVwUsuario extends GxActiveRecord {

    public static function model($className=__CLASS__) {
        return parent::model($className);
    }

    public function tableName() {
        return 'siaudi.vw_usuario';
    }

    public static function label($n = 1) {
        return Yii::t('app', 'VwUsuario|VwUsuarios', $n);
    }

    public static function representingColumn() {
        return 'login';
    }

    public function rules() {
        return array(
            array('matricula', 'numerical', 'integerOnly' => true),
            array('login, email', 'length', 'max' => 100),
            array('funcao, nome_usuario', 'length', 'max' => 60),
            array('nome_und_adm', 'length', 'max' => 80),
            array('sigla_und_adm', 'length', 'max' => 20),
            array('uf_und_adm', 'length', 'max' => 2),
            array('id_usuario, situacao, cpf, id_und_adm', 'safe'),
            array('id_usuario, login, funcao, nome_usuario, email, matricula, situacao, cpf, id_und_adm, nome_und_adm, sigla_und_adm, uf_und_adm', 'default', 'setOnEmpty' => true, 'value' => null),
            array('id_usuario, login, funcao, nome_usuario, email, matricula, situacao, cpf, id_und_adm, nome_und_adm, sigla_und_adm, uf_und_adm', 'safe', 'on' => 'search'),
        );
    }

    public function relations() {
        return array(
        );
    }

    public function pivotModels() {
        return array(
        );
    }

    public function attributeLabels() {
        return array(
            'id_usuario' => Yii::t('app', 'Id Usuario'),
            'login' => Yii::t('app', 'Login'),
            'funcao' => Yii::t('app', 'Funcao'),
            'nome_usuario' => Yii::t('app', 'Nome Usuario'),
            'email' => Yii::t('app', 'Email'),
            'matricula' => Yii::t('app', 'Matricula'),
            'situacao' => Yii::t('app', 'Situacao'),
            'cpf' => Yii::t('app', 'Cpf'),
            'id_und_adm' => Yii::t('app', 'Id Und Adm'),
            'nome_und_adm' => Yii::t('app', 'Nome Und Adm'),
            'sigla_und_adm' => Yii::t('app', 'Sigla Und Adm'),
            'uf_und_adm' => Yii::t('app', 'Uf Und Adm'),
        );
    }

    public function search() {
        $criteria = new CDbCriteria;

        $criteria->compare('id_usuario', $this->id_usuario, true);
        $criteria->compare('login', $this->login, true);
        $criteria->compare('funcao', $this->funcao, true);
        $criteria->compare('nome_usuario', $this->nome_usuario, true);
        $criteria->compare('email', $this->email, true);
        $criteria->compare('matricula', $this->matricula);
        $criteria->compare('situacao', $this->situacao, true);
        $criteria->compare('cpf', $this->cpf, true);
        $criteria->compare('id_und_adm', $this->id_und_adm, true);
        $criteria->compare('nome_und_adm', $this->nome_und_adm, true);
        $criteria->compare('sigla_und_adm', $this->sigla_und_adm, true);
        $criteria->compare('uf_und_adm', $this->uf_und_adm, true);

        return new CActiveDataProvider($this, array(
                    'criteria' => $criteria,
                ));
    }

}