/*
 * Decompiled with CFR 0.152.
 */
package br.gov.bcb.relatorio.recor.infraestrutura;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.apache.commons.beanutils.PropertyUtils;

public class JRBeanIteratorDataSource
implements JRDataSource {
    private Iterator iterator;
    private Object currentBean;

    public JRBeanIteratorDataSource(Iterator iterator) {
        this.iterator = iterator;
    }

    public boolean next() throws JRException {
        boolean hasNext = false;
        if (this.iterator != null && (hasNext = this.iterator.hasNext())) {
            this.currentBean = this.iterator.next();
        }
        return hasNext;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        Object value = null;
        if (this.currentBean != null) {
            try {
                value = PropertyUtils.getProperty((Object)this.currentBean, (String)jrField.getName());
            }
            catch (IllegalAccessException e) {
                throw new JRException("Error retrieving field value from bean : " + jrField.getName(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new JRException("Error retrieving field value from bean : " + jrField.getName(), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new JRException("Error retrieving field value from bean : " + jrField.getName(), (Throwable)e);
            }
        }
        return value;
    }
}

