/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.sql.Connection;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillInterruptedException;
import net.sf.jasperreports.engine.fill.JRHorizontalFiller;
import net.sf.jasperreports.engine.fill.JRVerticalFiller;

public abstract class JRFiller {
    public static JasperPrint fillReport(JasperReport jasperReport, Map parameters, Connection conn) throws JRException {
        JRBaseFiller filler = null;
        switch (jasperReport.getPrintOrder()) {
            case 2: {
                filler = new JRHorizontalFiller(jasperReport);
                break;
            }
            case 1: {
                filler = new JRVerticalFiller(jasperReport);
            }
        }
        JasperPrint jasperPrint = null;
        try {
            jasperPrint = filler.fill(parameters, conn);
        }
        catch (JRFillInterruptedException e) {
            throw new JRException("The report filling thread was interrupted.");
        }
        return jasperPrint;
    }

    public static JasperPrint fillReport(JasperReport jasperReport, Map parameters, JRDataSource dataSource) throws JRException {
        JRBaseFiller filler = null;
        switch (jasperReport.getPrintOrder()) {
            case 2: {
                filler = new JRHorizontalFiller(jasperReport);
                break;
            }
            case 1: {
                filler = new JRVerticalFiller(jasperReport);
            }
        }
        JasperPrint jasperPrint = null;
        try {
            jasperPrint = filler.fill(parameters, dataSource);
        }
        catch (JRFillInterruptedException e) {
            throw new JRException("The report filling thread was interrupted.");
        }
        return jasperPrint;
    }
}

