/*
 * Created on 12/01/2007
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package chat.controlador;

import java.util.Iterator;

import javax.servlet.http.HttpSession;

import chat.dto.*;

/**
 * @author daniel.freitas
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class UtilChat {
	
	public static String montaMensagemEntrada(String usuario){
		return "<tr><td><strong>"+usuario+"</strong> acabou de entrar <br><br></td></tr>";
	}
	
	public static String montaMensagemReconexao(String usuario){
		return "<tr><td><strong>"+usuario+"</strong> reconectou no chat <br><br></td></tr>";
	}
	
	public static String montaMensagemEntradaDestacado(String usuario){
		return "<table width='580'><tr><td bgcolor='#CCCCCC'><strong>"+usuario+"</strong> acabou de entrar <br><br></td></tr>";
	}
	
	public static String montaMensagemReconexaoDestacado(String usuario){
		return "<table width='580'><tr><td bgcolor='#CCCCCC'><strong>"+usuario+"</strong> reconectou no chat <br><br></td></tr>";
	}
	
	public static String montaCabecalhoPadraoMensagem(String remetente, String destinatario, String mensagem){
		if(mensagem!=null)
			return "<tr><td><strong>"+remetente+"</strong> fala para <strong>"+destinatario+"</strong>: "+mensagem+" <br><br></td></tr>";
		return null;
	}
	
	public static String montaCabecalhoPadraoMensagemDestacada(String remetente, String destinatario, String mensagem){
		if(mensagem!=null)
			return "<tr><td bgcolor='#CCCCCC'><strong>"+remetente+"</strong> fala para <strong>"+destinatario+"</strong>: "+mensagem+" <br><br></td></tr>";
		return null;
	}
	
	public static String montaCabecalhoMensagemReservadaDestacada(String remetente, String destinatario, String mensagem){
		return "<tr><td  bgcolor='#CCCCCC'><strong>"+remetente+"</strong> fala reservadamente para <strong>"+destinatario+"</strong>: "+mensagem+" <br><br></td></tr>";
	}
	
	public static String montaCabecalhoMensagemReservadaSemDestaque(String remetente, String destinatario, String mensagem){
		return "<tr><td><strong>"+remetente+"</strong> fala reservadamente para <strong>"+destinatario+"</strong>: "+mensagem+" <br><br></td></tr>";
	}
	
	public static String montaMensagemSaida(String usuario){
		return "<tr><td><strong>"+usuario+"</strong> acabou de sair <br><br></td></tr>";
	}
	
	public static void carregaBroadcastDeMensagens(String textoFinal,String textoFinalDestacado,Integer chaveRemetente, Integer chaveDestinatario) {
		LogMensagensDTO logMensagens;
		Iterator it = ApoioServidorDTO.getListaSessoes().iterator();
		while(it.hasNext()){
			SessaoDTO sessao = (SessaoDTO)it.next();
				try{
					logMensagens = carregaLogDasSessoesParaSerAlterado(sessao.getSessao());
					if(sessao != null && (isUsuarioLocalizadoParticipanteDaMensagem(chaveRemetente, sessao)	|| isUsuarioLocalizadoParticipanteDaMensagem(chaveDestinatario, sessao))){
						logMensagens.adicionaMensagemAoLog(textoFinalDestacado);
					}else{
						logMensagens.adicionaMensagemAoLog(textoFinal);
					}
					sessao.getSessao().setAttribute("logMensagens",logMensagens);
					sessao.getSessao().setAttribute("texto", logMensagens.recuperaLogMensagens());
				}catch(Exception e){
					e.printStackTrace();
				}
		}
	}
	
	private static boolean isUsuarioLocalizadoParticipanteDaMensagem(Integer chaveUsuario, SessaoDTO sessao) {
		return (chaveUsuario!=null && sessao.getUsuarioSessao().getChaveUsuario().intValue()==chaveUsuario.intValue());
	}

	private static LogMensagensDTO carregaLogDasSessoesParaSerAlterado(HttpSession sessao) {
		LogMensagensDTO logMensagens = (LogMensagensDTO)sessao.getAttribute("logMensagens");
		if(logMensagens==null){
			logMensagens = new LogMensagensDTO();
		}
		return logMensagens;
	}
	
	public static boolean isStringNulaOuVazia(String texto){
		return texto==null || texto.equals("");
	}
	
	public void teste(HttpSession secao){
		String isDentroDoChat = (String)secao.getAttribute("chat");
		String log = (String)secao.getAttribute("logMensagens");
		SessaoDTO sessaodto = (SessaoDTO)secao.getAttribute("sessao");
		System.out.println(isDentroDoChat);
	}

}
