package dao.propriedades;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import javax.servlet.ServletException;

public class Conexao {

	Properties conexoes = new Properties();

	private static Conexao conexao;

	private Conexao() {
	}

	public static Conexao getInstance() {
		if (conexao == null) {
			conexao = new Conexao();
		}
		return conexao;
	}

	public void carregarConexao(String arquivo) throws ServletException {
		try {
			if (arquivo == null) {
				throw new ServletException(
						"No foi possivel encontrar no descritor a variavel de inicializacao 'conexao'");
			}
			InputStream str = this.getClass().getClassLoader().getResourceAsStream(arquivo);
			if (str == null) {
				throw new ServletException(
						"No foi possivel encontrar o arquivo de conexao 'conexao.properties'");
			}
			conexoes.load(str);
		} catch (IOException e) {
			e.printStackTrace();
		}

	}

	public String obter(String chave) {
		return (String) conexoes.get(chave);
	}
}