package model;

import java.sql.SQLException;

import dao.AdministradorDAO;
import dao.DAOFactory;
import dto.AdministradorDTO;
import dto.LoginDTO;

public class AdministradorModel extends ModelBase{
	private AdministradorDAO dao;
	
	public AdministradorModel(LoginDTO login){
		super(login);
	}
	
	public AdministradorDTO buscarAministrador(Integer chavePessoa) {
		try {
			return getDao().buscarAdministrador(chavePessoa);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
		
	}
	
	
	
	public AdministradorDAO getDao() {
		if(dao == null)
			try {
				dao = (AdministradorDAO)DAOFactory.getInstance().getDAO("dao.AdministradorDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		return dao;
	}



}