package pmon.model;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.Collection;

import model.ModelBase;

import pmon.dao.ProfessorDAO;
import pmon.dto.AtendimentoDTO;
import dao.DAOFactory;
import dto.LoginDTO;

public class ProfessorModel extends ModelBase{
	private ProfessorDAO dao;
	
	public ProfessorModel(LoginDTO login) {
		super(login);
	}
	
	public Collection listarProfessores() {
		try {
			return getDao().listar();
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return null;
	}
	private ProfessorDAO getDao(){
		if(dao ==null)
			try {
				dao = (ProfessorDAO)DAOFactory.getInstance().getDAO("pmon.dao.ProfessorDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (SQLException e) {
				e.printStackTrace();
			} catch (InstantiationException e) {
				e.printStackTrace();
			}
		return dao;
	}
	public boolean getTurmaAluno(AtendimentoDTO dto)  throws SQLException, ParseException{
		return getDao().getTurmaAluno(dto);
		
	}

}
