/*
 * Created on 23/01/2007
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package questao.model;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.*;

import model.ModelBase;

import questao.dao.*;
import questao.dto.*;
import questao.validacao.apoio.ApoioLista;
import dao.DAOFactory;
import dto.LoginDTO;
import dto.TurmaDTO;

/**
 * @author daniel.freitas
 * 
 * To change the template for this generated type comment go to Window - Preferences - Java - Code
 * Generation - Code and Comments
 */
public class ListaModel extends ModelBase{
	private ListaDAO dao;
	private ListaQuestaoDAO daoListaQuestao;
	private ListaTurmaDAO daoListaTurma;
	
	public ListaModel(LoginDTO login) {
		super(login);
	}

	public Collection listarTodasListas() throws SQLException {
		return (getDao().listarTodasListas());
	}

	public void cadastrarLista(ListaDTO dto, List listaQuestoes)
			throws SQLException {
		getDao().cadastrarLista(dto);
		Integer idLista = getDao().buscarUltimoIdLista();
		Iterator it = listaQuestoes.iterator();
		while(it.hasNext()){
			QuestaoDTO questaoTemp = (QuestaoDTO)it.next();
			getDaoListaQuestao().cadastrarLista(idLista,questaoTemp.getIdQuestao());
		}
	}
	
	public void cadastrarListaTurma(TurmaDTO dto, Integer idLista, Date dtLimiteEntrega, Date horarioLimiteEntrega)
			throws SQLException {
		getDaoListaTurma().cadastrarListaTurma(dto,idLista,dtLimiteEntrega,horarioLimiteEntrega);
	}
	
	public void excluir(Integer idLista) throws SQLException {
		getDaoListaQuestao().excluirLista(idLista);
		getDao().excluirLista(idLista);
	}
	
	public void excluirListaDaTurma(Integer idLista, TurmaDTO turma) throws SQLException {
		getDaoListaTurma().excluirListaDaTurma(idLista,turma);
	}

	public ListaDTO buscarLista(Integer idLista) throws SQLException {
		return getDao().buscarLista(idLista);
	}
	
	public ApoioLista buscarListaApoioLista(Integer idLista) throws SQLException {
		return getDao().buscarListaApoioLista(idLista);
	}

	public void alterarLista(ListaDTO dto) throws SQLException {
		getDao().alterarLista(dto);
	}

	public Collection buscarListaPorTitulo(String titulo) throws SQLException {
		return getDao().buscarListaPorTitulo(titulo);
	}
	
	public Collection buscarListaDaTurma(TurmaDTO dtoTurma) throws ParseException, SQLException {
		return getDaoListaTurma().buscarListaPorTitulo(dtoTurma);
	}
	
	public ListaTurmaDTO buscarListaDaTurmaPorId(String idLista, TurmaDTO dtoTurma) throws ParseException, SQLException {
		return getDaoListaTurma().buscarListaDaTurmaPorId(idLista, dtoTurma);
	}
	
	public Collection buscarTodasListaETurmas()  throws ParseException, SQLException{
		return getDaoListaTurma().buscarTodasListaETurmas();
	}
	
	public Collection buscarTodasListaETurmasDoAluno(String chaveAluno)  throws ParseException, SQLException{
		return getDaoListaTurma().buscarTodasListaETurmasEChaveAluno(chaveAluno);
	}

	public ListaTurmaDTO buscaDataLimiteParaLista(ListaDTO lista, String chaveAluno)  throws ParseException, SQLException{
		return getDaoListaTurma().buscaDataLimiteParaLista(lista,chaveAluno);
	}

	public ListaDAO getDao() throws SQLException {
		if (this.dao == null)
			try {
				this.dao = (ListaDAO) DAOFactory.getInstance().getDAO("questao.dao.ListaDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		return this.dao;
	}
	
	public ListaQuestaoDAO getDaoListaQuestao() throws SQLException {
		if (this.daoListaQuestao == null)
			try {
				this.daoListaQuestao = (ListaQuestaoDAO) DAOFactory.getInstance().getDAO("questao.dao.ListaQuestaoDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		return this.daoListaQuestao;
	}
	
	public ListaTurmaDAO getDaoListaTurma() throws SQLException {
		if (this.daoListaTurma == null)
			try {
				this.daoListaTurma = (ListaTurmaDAO) DAOFactory.getInstance().getDAO("questao.dao.ListaTurmaDAO",  getLoginDTOUsuarioLogado());
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		return this.daoListaTurma;
	}
	
}