

import java.text.SimpleDateFormat;
import java.util.TimeZone;

public class DatasComTimeZone {


	public static void main(String[] args) {
		//Teste de datas com time Zone diferentes
		
		/**
		 * Aqui não houve modificação da Data, é a mesma do sistema
		 */
		System.out.println("Hora Sem Formatar (TZ padrão): " +getHoraComTimeZoneDefault());
		
		/**
		 * Aqui foi ajustado para Brasília. Se a hora estiver correta para o timezone da máquina
		 * vai mostrar o horário de Brasília.
		 */
		System.out.println("Hora em Brasília (GMT-3:00): " + getHoraBrasilia());
		
		System.out.println("Hora em Fernando de Noronha (GMT-2:00): " + getHoraFernandoDeNoronha());
		
		System.out.println("Hora em pequim China (GMT+8:00): " + getHoraPequim());
		

	}
	
	public static String getHoraComTimeZoneDefault()
	{   SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
		sdf.setTimeZone(TimeZone.getTimeZone("GMT-0:00"));
		return sdf.format(new java.util.Date()).toString();
	}
	public static String getHoraBrasilia()
	{   SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
		sdf.setTimeZone(TimeZone.getTimeZone("GMT-3:00"));
		return sdf.format(new java.util.Date()).toString();
	}
	public static String getHoraFernandoDeNoronha()
	{   SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
		sdf.setTimeZone(TimeZone.getTimeZone("GMT-2:00"));
		return sdf.format(new java.util.Date()).toString();
	}
	public static String getHoraPequim()
	{   SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
		sdf.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
		return sdf.format(new java.util.Date()).toString();
	}

}
