package acao;

import java.sql.SQLException;

import javax.servlet.http.*;

import model.LoginModel;
import slave.Dominio;
import dto.LoginDTO;

public class AlterarLoginAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		LoginModel model = new LoginModel(login);
		
		LoginDTO dto = new LoginDTO(req.getParameter("login"),req.getParameter("senha"));
		dto.setPerfil(((LoginDTO)secao.getAttribute("loginDTO")).getPerfil());
		
		try{
			dto = model.verificarLogin(dto); //agora esse dto tem a chave caso haja sucesso na busca.
		}catch (SQLException e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			e.printStackTrace();
			return "/abrirAlterarLogin.do";
		}
		
		if(dto.getChavePessoa() == null){
			req.setAttribute("mensagem","A senha atual est incorreta.");
			return "/abrirAlterarLogin.do";
		}

		LoginDTO novoLogin = new LoginDTO(dto.getLogin(),req.getParameter("novaSenha"));
		if(!req.getParameter("confirmacaoSenha").equals(novoLogin.getSenha())|| novoLogin.getSenha().equalsIgnoreCase("")){
			req.setAttribute("mensagem","Os dados esto incorretos! Informe novamente.");
			return "/abrirAlterarLogin.do";
		}
		if(novoLogin.getSenha().length() < 4){
			req.setAttribute("mensagem","Senha invlida! A senha precisa ter no mnimo 4 caracteres.");
			return "/abrirAlterarLogin.do";
		}
		if(novoLogin.getSenha().length() > 10){
			req.setAttribute("mensagem","Senha invlida! A senha precisa ter no mximo 10 caracteres.");
			return "/abrirAlterarLogin.do";
		}
		dto.setLogin(novoLogin.getLogin());
		dto.setSenha(novoLogin.getSenha());
		model.alterarLogin(dto);
		secao.setAttribute("loginDTO",dto);//atualiza o logun na secao.
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/jsp/abertura.jsp";
	}

}
