package acao;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import model.LoginModel;
import slave.Dominio;

import com.google.code.kaptcha.Constants;

import dto.LoginDTO;

public class LogarAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		LoginDTO dto = new LoginDTO(req.getParameter("login"),req.getParameter("senha"));
		dto.setPerfil(new Integer(req.getParameter("perfil")));
		
		LoginModel model = new LoginModel(login);
		
		try{
			dto = model.verificarLogin(dto); //agora esse dto tem a chave caso haja sucesso na busca.
		}catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/jsp/login.jsp";
		}
		
		if(dto.getChavePessoa() == null){
			req.setAttribute("mensagem",Dominio.getMensagemFalhaNoLogin());
			
					
			if(req.getSession().getAttribute("habilitaCaptcha") == null){
				req.getSession().setAttribute("habilitaCaptcha", "desativo");
			}else{
				req.getSession().setAttribute("habilitaCaptcha", "ativo");
				
			}
			
			
			return "/jsp/login.jsp";
		}else{
			if(req.getSession().getAttribute("habilitaCaptcha") != null){
				if(((String)req.getSession().getAttribute("habilitaCaptcha")).equals("ativo")){
					if(model.VerificaImagem((String)req.getParameter("campoCaptcha"), (String)req.getSession().getAttribute(Constants.KAPTCHA_SESSION_KEY))){
						HttpSession secao = req.getSession();
						secao.setAttribute("loginDTO",dto);
						req.setAttribute("loginDTO",dto);
						req.getSession().removeAttribute("habilitaCaptcha");
						return "/principal.do";				
					}
					else{
						req.setAttribute("mensagem",Dominio.getMensagemFalhaNoCaptcha());
						return "/jsp/login.jsp";						
					}
				}
				else{
					HttpSession secao = req.getSession();
					secao.setAttribute("loginDTO",dto);
					req.setAttribute("loginDTO",dto);
					req.getSession().removeAttribute("habilitaCaptcha");
					return "/principal.do";			
				}
			}else{
				HttpSession secao = req.getSession();
				secao.setAttribute("loginDTO",dto);
				req.setAttribute("loginDTO",dto);
				req.getSession().removeAttribute("habilitaCaptcha");
				return "/principal.do";
			}
		}
	}

}
