package acao;

import javax.servlet.http.*;

import pmon.model.AtendimentoModel;
import slave.Dominio;

import model.*;
import dto.*;

public class PrincipalAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		LoginDTO dto = (LoginDTO)req.getAttribute("loginDTO");	
		if(dto.getPerfil().intValue() == 1){
			
			AdministradorModel model = new AdministradorModel(login);
			HttpSession secao = req.getSession();
			resetOtherSession(secao,"administrador");
			AdministradorDTO admin = new AdministradorDTO();
			admin = model.buscarAministrador(dto.getChavePessoa());
			secao.setAttribute("administrador",admin);
			secao.setAttribute("perfil",dto.getPerfil());
			secao.setAttribute("contexto","Geral");
			
		}
		else if(dto.getPerfil().intValue() == 5){
			
			MonitorModel model = new MonitorModel(login);
			MonitorDTO monitor = new MonitorDTO();
			HttpSession secao = req.getSession();
			resetOtherSession(secao,"administrador");
			monitor = model.buscarMonitor(dto.getChavePessoa());
			secao.setAttribute("monitor",monitor);
			secao.setAttribute("perfil",dto.getPerfil());
			secao.setAttribute("contexto","Geral");
			
		}else if(dto.getPerfil().intValue() == 2){
			
			AlunoModel model = new AlunoModel(login);
			AlunoDTO aluno = new AlunoDTO();
			HttpSession secao = req.getSession();
			resetOtherSession(secao,"aluno");
			aluno = model.buscarAluno(dto.getChavePessoa());
			secao.setAttribute("aluno",aluno);
			secao.setAttribute("perfil",dto.getPerfil());
			secao.setAttribute("contexto","Geral");
		}else if(dto.getPerfil().intValue() == 3){
			
			ProfessorModel model = new ProfessorModel(login);
			ProfessorDTO professor = new ProfessorDTO();
			HttpSession secao = req.getSession();
			resetOtherSession(secao,"professor");
			professor = model.buscarProfessor(dto.getChavePessoa());
			secao.setAttribute("professor",professor);
			secao.setAttribute("perfil",dto.getPerfil());
			secao.setAttribute("contexto","Geral");
			
		}else if(dto.getPerfil().intValue() == 4){
			
			DiretorModel model = new DiretorModel(login);
			DiretorDTO diretor = new DiretorDTO();
			HttpSession secao = req.getSession();
			resetOtherSession(secao,"diretor");
			diretor = model.buscarDiretor(dto.getChavePessoa());
			secao.setAttribute("diretor",diretor);
			secao.setAttribute("perfil",dto.getPerfil());
			secao.setAttribute("contexto","Geral");
		}
			
		
		if(dto.getPerfil().intValue() == Dominio.getProfessor().intValue()){ //professor{
			AtendimentoModel atModel = new AtendimentoModel(login);
			HttpSession secao = req.getSession();
			secao.setAttribute("novaNotificacao",atModel.temParecerComNotificacaoNaoLido(dto.getChavePessoa()));
		}
		if(dto.getPerfil().intValue() == Dominio.getMonitor().intValue()){ //monitor
			AtendimentoModel atModel = new AtendimentoModel(login);
			HttpSession secao = req.getSession();
			secao.setAttribute("novaNotificacao",atModel.temParecerComNotificacaoNaoLidoMonitor(dto.getChavePessoa()));
		}
		
		
		return "/jsp/principal.jsp";
	}
	private void resetOtherSession(HttpSession secao,String secaoAtual){
		String []secoes = {"administrador","monitor","diretor","aluno","professor"};
		for (int i = 0; i < secoes.length; i++) {
			if(!secaoAtual.equalsIgnoreCase(secoes[i])){
				secao.setAttribute(secoes[i],null);
			}
			
		}
	}

}
