package acao;

import javax.servlet.http.*;

import chat.controlador.UtilChat;
import chat.dto.ApoioServidorDTO;
import chat.dto.SessaoDTO;

public class SairAcao implements Acao{
	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession();
//		secao.setAttribute("loginDTO",null);
//		secao.setAttribute("perfil",null);
		secao.removeAttribute("loginDTO");
		secao.removeAttribute("perfil");
		
		
		//CONTROLE DO CHAT
		String chatAberto = (String)req.getSession().getAttribute("chatAberto");
		if(chatAberto!=null){
			SessaoDTO sessaoAtual = (SessaoDTO)req.getSession().getAttribute("sessao");
			if(sessaoAtual!=null){
	    		String usuarioSaida = sessaoAtual.getUsuarioSessao().getLogin();
		    	ApoioServidorDTO.getListaUsuarios().remove(sessaoAtual.getUsuarioSessao());
		    	ApoioServidorDTO.getListaSessoes().remove(sessaoAtual);
	    		carregaBroadcastDeMensagensParaSaidaDeUsuario(usuarioSaida);
	    		secao.removeAttribute("logMensagens");
	    		secao.removeAttribute("sessao");
	    		secao.removeAttribute("chat");
	    		secao.removeAttribute("chatAberto");
	    		secao.removeAttribute("acaoAnterior");
	    		secao.removeAttribute("reservado");
	    		secao.removeAttribute("destinatario");
	    		secao.removeAttribute("chaveDestinatario");
			}
		}
		secao.invalidate();
		return "/index.do";
	}
	
	private void carregaBroadcastDeMensagensParaSaidaDeUsuario(String usuarioSaida) {
		UtilChat.carregaBroadcastDeMensagens(UtilChat.montaMensagemSaida(usuarioSaida),null,null,null);
	}
	
}
