package acao.aluno;
import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.*;

import model.CursoModel;
import slave.Dominio;
import validacao.apoio.ApoioAluno;
import validacao.message.MessageErrorAluno;
import acao.Acao;
import dto.CursoDTO;
import dto.LoginDTO;

public class AbrirCadastroAlunoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		Integer chavePessoa = new Integer(req.getParameter("chavePessoa"));
		HttpSession secao = req.getSession();
		secao.setAttribute("execucao","Cadastrar");
		secao.setAttribute("chavePessoa",chavePessoa);
		
		CursoModel model = new CursoModel(login);
		
		Collection col=null;
		try{
			col = model.listarTodosCursos();//lancar exception para tratar erro com o banco!!!!!
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarAluno.do";
		}
		
		req.setAttribute("cursos",col);
		if(req.getAttribute("erro") == null){
			MessageErrorAluno mep = new MessageErrorAluno();
			req.setAttribute("erro",mep);
		}
		if(req.getAttribute("apoio") == null){
			ApoioAluno aa = new ApoioAluno();
			ArrayList list = (ArrayList)col;
			CursoDTO dto = (CursoDTO)list.get(0);
			aa.setCodigoCurso(dto.getCodigoCurso().toString());
			req.setAttribute("apoio",aa);
		}
		return "/jsp/aluno/cadastrarAluno.jsp";
	}

}