package acao.aluno;

import java.util.Collection;

import javax.servlet.http.*;

import dto.LoginDTO;

import model.CursoModel;
import slave.Dominio;
import acao.Acao;

public class AbrirVisualizarAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		secao.setAttribute("execucao","Visualizar");
		CursoModel model = new CursoModel(login);
		
		Collection col=null;
		try{
			col = model.listarTodosCursos();
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarAluno.do";
		}
		req.setAttribute("cursos",col);
		return "/buscarAluno.do";
	}

}
