package acao.aluno;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.*;

import model.AlunoModel;
import slave.Dominio;
import validacao.ValidacaoCamposAluno;
import validacao.apoio.ApoioAluno;
import validacao.message.MessageErrorAluno;
import acao.Acao;
import dto.AlunoDTO;
import dto.LoginDTO;

public class AlterarAlunoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		//***************parte responsavel pela validacao e mensagens e manter campos
		HttpSession secao = req.getSession();
		MessageErrorAluno mea = new MessageErrorAluno();
		ApoioAluno aa = new ApoioAluno();
		loadAlunoApoio(req,aa);//coloca os dados da requisicao na classe de apoio
		try{
			ValidacaoCamposAluno.validaAluno(aa,mea);
		}catch (Exception e) {
			req.setAttribute("erro",mea);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/abrirAlterarAluno.do?chavePessoa="+secao.getAttribute("chavePessoa")+"&acao=ALTERAR";
		}
		//***********************************************************************
		
		
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		AlunoDTO dto = new AlunoDTO();//somente os dados especificos serao setados.
		
		dto.setChavePessoa((Integer)secao.getAttribute("chavePessoa"));
		
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		java.util.Date dtRegistro = sdf.parse(req.getParameter("dtRegistro"));
		dto.setDtRegistro(new Date(dtRegistro.getTime()));
		
		dto.setCodigoCurso(new Integer(req.getParameter("codigoCurso")));
		dto.setMatricula(req.getParameter("matricula"));
		dto.setSituacao(req.getParameter("situacao"));
		AlunoModel model = new AlunoModel(login);
		
		try{
			model.alterarAluno(dto);
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			e.printStackTrace();
			return "/abrirPesquisarAluno.do";
		}
		
		
		Collection col = new ArrayList();
		try{
			col.add(model.buscarAluno(dto.getChavePessoa()));
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarAluno.do";
		}
		
		
		req.setAttribute("alunos",col);
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisarAluno.do";
	}
	private void loadAlunoApoio(HttpServletRequest req,ApoioAluno aa){
		
		aa.setCodigoCurso(req.getParameter("codigoCurso"));
		aa.setDtRegistro(req.getParameter("dtRegistro"));//quando eh insercao coloca a data do sistema
		aa.setMatricula(req.getParameter("matricula"));
		aa.setSituacao(req.getParameter("situacao"));
		req.setAttribute("apoio",aa);
		
	}
}
