package acao.aluno;

import javax.servlet.http.*;

import model.AlunoModel;
import model.PessoaModel;
import slave.Dominio;
import validacao.ValidacaoDadosCadastraisMonitorAluno;
import validacao.message.MessageErrorPessoa;
import acao.Acao;
import dto.*;
import dto.AlunoDTO;
import dto.PessoaDTO;

public class AlterarDadosCadastraisAlunoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		PessoaDTO dto = new PessoaDTO();
		HttpSession secao = req.getSession();
		//***************parte responsavel pela validacao e mensagens e manter campos
		MessageErrorPessoa mep = new MessageErrorPessoa();
		try{
			ValidacaoDadosCadastraisMonitorAluno.validaDadosCadastrais(req,mep);
		}catch (Exception e) {
			req.setAttribute("erro",mep);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/dadosCadastraisAluno.do";
		}
		//***********************************************************************
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		AlunoDTO aluno = (AlunoDTO)secao.getAttribute("aluno");
		dto.setChavePessoa(aluno.getChavePessoa());
		dto.setApelido(req.getParameter("apelido"));
		dto.setEmail(req.getParameter("email"));
		dto.setWebPessoal(req.getParameter("webPessoal"));
		
		PessoaModel model = new PessoaModel(login);
		model.alterarDadosCadastrais(dto);
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		//agora que os dados foram atualizados  necessrio atualizar os dados da secao.
		AlunoModel modAluno = new AlunoModel(login);
		
		aluno = modAluno.buscarAluno(aluno.getChavePessoa());
		secao.setAttribute("aluno",aluno);
		return "/jsp/abertura.jsp";

	}

}
