package acao.aluno;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import model.AlunoModel;
import slave.Dominio;
import acao.Acao;

public class PesquisarAlunosAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		String nomeAluno = req.getParameter("nomeAluno");
		String matricula = req.getParameter("matricula");
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		AlunoModel model = new AlunoModel(login);
		
		Collection col;
		try{
			col  = model.buscaAlunos(nomeAluno,matricula);
			
			if(col.size()<1)
				req.setAttribute("mensagemPesquisa",Dominio.getMensagemNenhumItemEncontrado());
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			e.printStackTrace();
			return "/abrirPesquisarAluno.do";
		}
		req.setAttribute("alunos",col);
		return "/jsp/aluno/listarAluno.jsp";
	}

}
