package acao.configuracao;

import javax.servlet.http.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import validacao.apoio.ApoioConfiguracao;
import validacao.apoio.ApoioCurso;
import validacao.message.MessageErrorConfiguracao;
import validacao.message.MessageErrorCurso;

import acao.Acao;

public class AbrirConfigurarSistemaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession(false);
		secao.setAttribute("contexto","Configurao");
		secao.setAttribute("execucao","Incio");
		
		if(req.getAttribute("erro") == null){
			MessageErrorConfiguracao mec = new MessageErrorConfiguracao();
			req.setAttribute("erro",mec);
		}
		if(req.getAttribute("apoio") == null){
			ApoioConfiguracao ac = new ApoioConfiguracao();
			req.setAttribute("apoio",ac);
		}
		
		return "/jsp/configuracao/configuracaoSistema.jsp";
	}
}
