package acao.configuracao;

import java.io.*;
import java.util.Iterator;
import java.util.List;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.*;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

import slave.ConfiguracaoPropriedades;
import slave.Dominio;
import validacao.ValidacaoCamposConfiguracao;
import validacao.apoio.ApoioConfiguracao;
import validacao.message.MessageErrorConfiguracao;
import acao.Acao;

public class ConfigurarSistemaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		
		MessageErrorConfiguracao mep = new MessageErrorConfiguracao();
		try{
//			ValidacaoCamposConfiguracao.validaConfiguracao(req,mep);
		}catch (Exception e) {
			req.setAttribute("erro",mep);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/abrirConfigurarSistema.do";
		}
		
		String altImagem = null;
		String titleImagem = null;
		String nomeImagem = null;
		
		FileItemFactory factory = new DiskFileItemFactory();
		 
		ServletFileUpload upload = new ServletFileUpload(factory);


		try {
			List items = upload.parseRequest(req);
			Iterator iter = items.iterator();

			while (iter.hasNext()) {
				FileItem item = (FileItem) iter.next();
				if (item.getFieldName().equals("altImagem")) {
					altImagem = item.getString();
				}else if (item.getFieldName().equals("titleImagem")) {
					titleImagem = item.getString();
				}else if (!item.isFormField()) {
					if (item.getName().length() > 0) {
						nomeImagem = this.inserirImagemDiretorio(item, req);
					}
				}
			}
			carregaArquivoDeProperties(req, altImagem, titleImagem, nomeImagem);
		}catch (IOException ex) {
			req.setAttribute("mensagem","No foi possivel realizar upload!");
			return "/abrirTelaInicialDePessoa.do";
		} catch (FileUploadException ex) {
			req.setAttribute("mensagem","No foi possivel realizar upload!");
			return "/abrirTelaInicialDePessoa.do";
		} catch (Exception ex) {
			req.setAttribute("mensagem","No foi possivel realizar upload!");
			return "/abrirTelaInicialDePessoa.do";
		}
		
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirTelaInicialDePessoa.do";
	}
	
	 private void carregaArquivoDeProperties(HttpServletRequest req, String altImagem, String titleImagem, String nomeImagem) throws IOException {
		ConfiguracaoPropriedades propriedades = ConfiguracaoPropriedades.getInstance();
		propriedades.setALT_IMAGEM(altImagem);
		propriedades.setTITLE_IMAGEM(titleImagem);
		propriedades.setIMAGEM_NAME(nomeImagem);
		propriedades.putPropierties(req);
	}

	private String inserirImagemDiretorio(FileItem item, HttpServletRequest req) throws IOException 
	 {
	 		ServletContext contexto = req.getSession().getServletContext();
			String caminho = contexto.getRealPath("/")+"imgs\\contexto";
			
			// Cria o diretrio caso ele no exista
			File diretorio = new File(caminho);
			
			if (!diretorio.exists())
			{
				diretorio.mkdir();
			
			}
			
			// Mandar o arquivo para o diretrio informado
			String nomeParcial = item.getName();
			int posicao = nomeParcial.lastIndexOf(".");
			String nome = "logo"+nomeParcial.substring(posicao).toLowerCase();
			String arq[] = nome.split("\\\\");
			
			for (int i = 0; i < arq.length; i++) 
			{
				nome = arq[i];
			}
			
			File file = new File(diretorio, nome);
			FileOutputStream output = new FileOutputStream(file);
			InputStream is = item.getInputStream();
			byte[] buffer = new byte[2048];
			
			int nLidos;
			
			while ((nLidos = is.read(buffer)) >= 0) 
			{
				output.write(buffer, 0, nLidos);
			}
			output.flush();
			output.close();
			return nome;
	 }

}


