package acao.conteudo;

import javax.servlet.http.*;

import model.DisciplinaModel;
import slave.Dominio;
import validacao.apoio.ApoioConteudo;
import validacao.message.MessageErrorConteudo;
import acao.Acao;
import dto.DisciplinaDTO;
import dto.LoginDTO;

public class AbrirCadastroConteudoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession(false);
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		String idDisciplina = req.getParameter("idDisciplina");
		
		DisciplinaDTO disciplina=null;
		if(idDisciplina!=null){
			DisciplinaModel modelDisciplina = new DisciplinaModel(login);
						
			try{
				disciplina = modelDisciplina.buscarDisciplina(new Integer(idDisciplina));
			}catch (Exception e) {
				req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
				return "/abrirPesquisarConteudo.do";
			}
		}
		secao.setAttribute("execucao","Cadastrar");
		
		if(disciplina!=null){
			secao.setAttribute("disciplina",disciplina);
			if(req.getAttribute("erro") == null){
				MessageErrorConteudo mec = new MessageErrorConteudo();
				req.setAttribute("erro",mec);
			}
			if(req.getAttribute("apoio") == null){
				ApoioConteudo ac = new ApoioConteudo();
				req.setAttribute("apoio",ac);
			}
			return "/jsp/conteudo/cadastrarConteudo.jsp";
		}
		return "/pesquisarDisciplinas.do";
	}
	
}
