package acao.conteudo;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import slave.Dominio;

import dto.DisciplinaDTO;
import dto.LoginDTO;

import model.ConteudoModel;
import model.DisciplinaModel;

import acao.Acao;

public class AbrirOrdenarConteudoAcao implements Acao{
	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession(false);
		secao.setAttribute("execucao","Ordenar");
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		ConteudoModel model = new ConteudoModel(login);
		DisciplinaModel disModel = new DisciplinaModel(login);
		Collection conteudos = new ArrayList();
		Integer idDisciplina = new Integer(req.getParameter("idDisciplina"));
		DisciplinaDTO disciplina = new DisciplinaDTO();
		try {
			disciplina = disModel.buscarDisciplina(idDisciplina);
			conteudos = model.buscarConteudosPorDisciplinaUsandoDTO(idDisciplina);
			if(conteudos.size()==0)
				req.setAttribute("mensagemPesquisa",Dominio.getMensagemNenhumItemEncontrado());
			req.setAttribute("conteudos",conteudos);
			req.setAttribute("disciplina",disciplina);
		} catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarConteudo.do";
		}
		return "/jsp/conteudo/ordenarConteudo.jsp";
	}
}
