package acao.conteudo;

import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.*;

import model.ConteudoModel;
import model.DisciplinaModel;
import slave.Dominio;
import acao.Acao;
import dto.DisciplinaDTO;
import dto.LoginDTO;

public class AbrirPesquisaConteudoPopUpAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession(false);
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
//		secao.setAttribute("contexto","Conteudo");
//		secao.setAttribute("execucao","Pesquisar");
		
		Collection col = null;
		DisciplinaDTO disciplina = null;
		
		//Teste para remover o disciplina da sessao
		String idDisciplina = req.getParameter("idDisciplina");
		if(idDisciplina==null) 
			secao.removeAttribute("disciplina");
		else{
			DisciplinaModel modelDisciplina = new DisciplinaModel(login);
			
			try{
				disciplina = modelDisciplina.buscarDisciplina(new Integer(idDisciplina));
			}catch (Exception e) {
				req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
				return "/abrirPesquisarConteudoPopUp.do";
			}
		}
		
		if(disciplina==null){
			col = new ArrayList();
		}else{
			ConteudoModel model = new ConteudoModel(login);
			
			try{
				col = model.buscarConteudosPorDisciplina(disciplina.getIdDisciplina());
			}catch (Exception e) {
				req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
				return "/abrirPesquisarConteudoPopUp.do";
			}
			secao.setAttribute("disciplina", disciplina);
		}
		req.setAttribute("conteudos",col);
		
		return "/jsp/conteudo/listarConteudoPopUp.jsp";
	}

}
