package acao.conteudo;

import javax.servlet.http.*;

import model.ConteudoModel;
import slave.Dominio;
import validacao.ValidacaoCamposConteudo;
import validacao.message.MessageErrorConteudo;
import acao.Acao;
import dto.ConteudoDTO;
import dto.LoginDTO;

public class AlterarConteudoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		
		HttpSession secao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		
		MessageErrorConteudo mec = new MessageErrorConteudo();

		try{
			ValidacaoCamposConteudo.validaConteudo(req,mec);
		}catch (Exception e) {
			req.setAttribute("erro",mec);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/abrirAlterarConteudo.do?idConteudo="+secao.getAttribute("idConteudo")+"&acao=ALTERAR";
		}
		//***********************************************************************
		ConteudoModel model = new ConteudoModel(login);
		ConteudoDTO dto = new ConteudoDTO();
		dto.setIdDisciplina(new Integer(req.getParameter("idDisciplina")));
		dto.setDescricao(req.getParameter("descricao"));
		dto.setMonitoria(new Integer(req.getParameter("monitoria")));
		dto.setQuestoes(new Integer(req.getParameter("questoes")));
		dto.setIdConteudo((Integer)secao.getAttribute("idConteudo"));
		secao.removeAttribute("idConteudo");
		try{
			model.alterarConteudo(dto);
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarConteudo.do";
		}
		
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisarConteudo.do";
	}

}
