package acao.conteudo;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import model.ConteudoModel;
import slave.Dominio;
import validacao.ValidacaoCamposConteudo;
import validacao.message.MessageErrorConteudo;
import acao.Acao;
import dto.ConteudoDTO;
import dto.LoginDTO;

public class CadastrarConteudoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		
		MessageErrorConteudo mec = new MessageErrorConteudo();

		try{
			ValidacaoCamposConteudo.validaConteudo(req,mec);
		}catch (Exception e) {
			req.setAttribute("erro",mec);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/abrirCadastrarConteudo.do";
		}
		//***********************************************************************
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		ConteudoModel model = new ConteudoModel(login);
		
		ConteudoDTO dto = new ConteudoDTO();
		dto.setIdDisciplina(new Integer(req.getParameter("idDisciplina")));
		dto.setDescricao(req.getParameter("descricao"));
		dto.setMonitoria(new Integer(req.getParameter("monitoria")));
		dto.setQuestoes(new Integer(req.getParameter("questoes")));
		try{
			model.cadastrarConteudo(dto);
		}catch (Exception e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarConteudo.do";
		}
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "abrirOrdenarConteudo.do?idDisciplina="+req.getParameter("idDisciplina")+"&contexto=manterConteudo";
		//return "/abrirPesquisarConteudo.do";
	}
}
