package acao.conteudo;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import model.ConteudoModel;
import slave.Dominio;
import acao.Acao;

public class ExcluirConteudoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		ConteudoModel model = new ConteudoModel(login);
		Integer idConteudo = new Integer(req.getParameter("idConteudo"));
		String idDisciplina = req.getParameter("idDisciplina");
		try{
			model.excluir(idConteudo);
		}catch(com.mysql.jdbc.exceptions.MySQLIntegrityConstraintViolationException a){
			System.out.println("Esse conteudo est sendo usado em outras partes da Aplicao,portanto no h como remov-lo sem antes desvincular esse conteudo!!! idConteudo["+idConteudo+"]");
			req.setAttribute("mensagem","Esse conteudo est sendo usado em outras partes da Aplicao,portanto no h como remov-lo sem antes desvincular esse contedo!!!");
			a.printStackTrace();
			return "/abrirPesquisarConteudo.do";
		}catch (Exception e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarConteudo.do";
		}

	    req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
	    
	    if(idDisciplina!=null)
	    	return "/abrirPesquisarConteudo.do?idDisciplina="+idDisciplina+"";
		return "/abrirPesquisarConteudo.do";
	}

}
