package acao.conteudo;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import model.ConteudoModel;
import slave.Dominio;
import acao.Acao;

public class ListarTodosConteudosAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		ConteudoModel model = new ConteudoModel(login);
		Collection col=null;
		try{
			col = model.listarTodosConteudos();
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarConteudo.do";
		}
		req.setAttribute("conteudos",col);
		return "/jsp/conteudo/listarConteudos.jsp";
	}

}
