package acao.conteudo;

import javax.servlet.http.*;

import dto.LoginDTO;

import model.ConteudoModel;
import slave.Dominio;
import acao.Acao;

public class MostraExclusaoAlteracaoConteudoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		ConteudoModel model = new ConteudoModel(login);
		
		Integer idConteudo = new Integer(req.getParameter("idConteudo"));
		try{
			req.setAttribute("conteudo",model.buscarConteudo(idConteudo));
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarConteudo.do";
		}
		
		HttpSession secao = req.getSession();
		secao.setAttribute("idConteudo",idConteudo);
		
		if(req.getParameter("acao").trim().equalsIgnoreCase("ALTERAR"))
			return "/jsp/conteudo/alterarConteudo.jsp";
		else if(req.getParameter("acao").trim().equalsIgnoreCase("VISUALIZAR"))
				return "/jsp/conteudo/visualizarConteudo.jsp";
		return "/jsp/conteudo/excluirConteudo.jsp";
	}
}
