package acao.conteudo;

import java.sql.SQLException;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import model.ConteudoModel;
import dto.LoginDTO;

import slave.Dominio;
import validacao.ValidacaoOrdenamentoConteudo;
import acao.Acao;

public class OrdenarConteudoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		Collection col = null;
		try {
			col = ValidacaoOrdenamentoConteudo.verificaOrdemDosConteudos(req);//os dto da tela com as ordem alteradas
		} catch (NumberFormatException number) {
			return "abrirOrdenarConteudo.do?idDisciplina="+req.getParameter("idDisciplina")+"&contexto="+req.getParameter("contexto");
		}catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirSelecionarDisciplina.do";
		}
		catch (Exception e) {//caso as entradas no estejam de acordo.
			e.printStackTrace();
			//mensagem j foi setada no validador
			return "abrirOrdenarConteudo.do?idDisciplina="+req.getParameter("idDisciplina")+"&contexto="+req.getParameter("contexto");
		}
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		ConteudoModel model = new ConteudoModel(login);
		try {
			model.ordenarConteudos(col);
		}catch (SQLException e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirSelecionarDisciplina.do";
		}
		req.setAttribute("mensagem","Ordenamento realizado com sucesso...");
		return "abrirOrdenarConteudo.do?idDisciplina="+req.getParameter("idDisciplina")+"&contexto="+req.getParameter("contexto");
	}
}
