package acao.conteudo;

import java.util.Collection;

import javax.servlet.http.*;

import model.ConteudoModel;
import slave.Dominio;
import acao.Acao;
import dto.DisciplinaDTO;
import dto.LoginDTO;

public class PesquisarConteudosPopUpAcao implements Acao {

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession sessao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		String nomeConteudo = req.getParameter("nomeConteudo");
		String nomeDisciplina = req.getParameter("nomeDisciplina");
		DisciplinaDTO disciplina = (DisciplinaDTO) sessao.getAttribute("disciplina");
		ConteudoModel model = new ConteudoModel(login);
		
		Collection listaConteudos = null;
		
		if (disciplina == null) {
			try {
				listaConteudos = model.buscarConteudosPorParteDescricaoENomeDisciplina(nomeConteudo,nomeDisciplina);
				req.setAttribute("conteudos", listaConteudos);
			} catch (Exception e) {
				req.setAttribute("mensagem", Dominio.getMensagemErroNaBaseDeDados());
				return "/abrirPesquisarConteudoPopUp.do";
			}
		} else {
			try {
				listaConteudos = model.buscarConteudosPorParteDaDescricaoEDisciplina(nomeConteudo, disciplina.getIdDisciplina());
				req.setAttribute("conteudos", listaConteudos);
			} catch (Exception e) {
				req.setAttribute("mensagem", Dominio.getMensagemErroNaBaseDeDados());
				return "/abrirPesquisarConteudo.do";
			}
		}
		
		if(listaConteudos.size()<1)
			req.setAttribute("mensagemPesquisa",Dominio.getMensagemNenhumItemEncontrado());
		
		return "/jsp/conteudo/listarConteudoPopUp.jsp";
	}
}