package acao.curso;

import javax.servlet.http.*;

import model.CursoModel;
import slave.Dominio;
import validacao.ValidacaoCamposCurso;
import validacao.message.MessageErrorCurso;
import acao.Acao;
import dto.CursoDTO;
import dto.LoginDTO;

public class AlterarCursoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		MessageErrorCurso mec = new MessageErrorCurso();

		try{
			ValidacaoCamposCurso.validaCurso(req,mec);
		}catch (Exception e) {
			req.setAttribute("erro",mec);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/abrirAlterarCurso.do?codigoCurso="+secao.getAttribute("codigoCurso")+"&acao=ALTERAR";
		}
		//***********************************************************************
		CursoModel model = new CursoModel(login);
		CursoDTO dto = new CursoDTO();
		dto.setNomeCurso(req.getParameter("nomeCurso"));
		
		dto.setCodigoCurso((Integer)secao.getAttribute("codigoCurso"));
		secao.removeAttribute("codigoCurso");
		try{
			model.alterarCurso(dto);
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarCurso.do";
		}
		
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisarCurso.do";
	}

}
