package acao.curso;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import model.CursoModel;
import slave.Dominio;
import validacao.ValidacaoCamposCurso;
import validacao.message.MessageErrorCurso;
import acao.Acao;
import dto.CursoDTO;
import dto.LoginDTO;
public class CadastrarCursoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		
		MessageErrorCurso mec = new MessageErrorCurso();

		try{
			ValidacaoCamposCurso.validaCurso(req,mec);
		}catch (Exception e) {
			req.setAttribute("erro",mec);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/abrirCadastrarCurso.do";
		}
		//***********************************************************************
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		CursoModel model = new CursoModel(login);
		CursoDTO dto = new CursoDTO();
		dto.setNomeCurso(req.getParameter("nomeCurso"));
		try{
			model.cadastrarCurso(dto);
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarCurso.do";
		}
		
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisarCurso.do";
	}
}
