package acao.curso;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import model.CursoModel;
import slave.Dominio;
import acao.Acao;

public class ExcluirCursoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		CursoModel model = new CursoModel(login);
		Integer codigoCurso = new Integer(req.getParameter("codigoCurso"));
		try{
			model.excluir(codigoCurso);
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarCurso.do";
		}
	    req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisarCurso.do";
	}

}
