package acao.curso;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import model.CursoModel;
import slave.Dominio;
import acao.Acao;

public class ListarTodosCursosAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		CursoModel model = new CursoModel(login);
		Collection col=null;
		try{
			col = model.listarTodosCursos();
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarCurso.do";
		}
		
		req.setAttribute("cursos",col);
		return "/jsp/curso/listarCursos.jsp";
	}

}
